﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Shared.Model.Config.MDWS;

namespace MedRed.Services
{
    public class ConnectionHelper
    {
        public static MDWSConfiguration GetDefaultConfig()
        {
            var config = new MDWSConfiguration();
            config.BaseMDWS_Url = "http://127.0.0.1/MDWS2/";

            config.DataSources.Add("555", new DataSource { SiteID = "555", Server = "127.0.0.1", Port = "9200" });
            config.DataSources.Add("556", new DataSource { SiteID = "556", Server = "127.0.0.1", Port = "9200" });
            config.DataSources.Add("557", new DataSource { SiteID = "557", Server = "127.0.0.1", Port = "9200" });

            config.ServiceAccounts.Add("555", new MDWSConnection() { SiteID = "555", AccessCode = "medred3", VerifyCode = "password" });
            config.ServiceAccounts.Add("556", new MDWSConnection() { SiteID = "556", AccessCode = "medred3", VerifyCode = "password" });
            config.ServiceAccounts.Add("557", new MDWSConnection() { SiteID = "557", AccessCode = "medred3", VerifyCode = "password" });

            config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingDB;Persist Security Info=True;User ID=sa;Password=password";

            config.Caldav_Source = new Shared.Model.Config.Calendar.CalendarConfiguration()
            {
                BaseCalendarUri = new Uri("http://127.0.0.1:8080/ucaldav/user/vbede/"),
                UserName = "vbede",
                Password = "bedework"
            };
            return config;
        }

        public static MDWSConfiguration GetVistAEMRConfig()
        {
            var config = new MDWSConfiguration();
            config.BaseMDWS_Url = "http://mdws.vistaehr.com/mdws2.8.0/";

            config.DataSources.Add("100", new DataSource { SiteID = "100", Server = "172.19.100.199", Port = "9200" });
            config.ServiceAccounts.Add("100", new MDWSConnection() { SiteID = "100", AccessCode = "9952FRN", VerifyCode = "MQGS)874" });

            config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingDB;Persist Security Info=True;User ID=sa;Password=password";
            config.Caldav_Source = new Shared.Model.Config.Calendar.CalendarConfiguration()
            {
                BaseCalendarUri = new Uri("http://127.0.0.1:8080/ucaldav/user/vbede/"),
                UserName = "vbede",
                Password = "bedework"
            };

            return config;
        }

        public static MDWSConfiguration GetTestingConfig()
        {
            var config = new MDWSConfiguration();
            config.BaseMDWS_Url = "http://127.0.0.1/MDWS2/";

            config.DataSources.Add("555", new DataSource { SiteID = "555", Server = "127.0.0.1", Port = "9200" });
            config.DataSources.Add("556", new DataSource { SiteID = "556", Server = "127.0.0.1", Port = "9200" });
            config.DataSources.Add("557", new DataSource { SiteID = "557", Server = "127.0.0.1", Port = "9200" });

            config.ServiceAccounts.Add("555", new MDWSConnection() { SiteID = "555", AccessCode = "medred3", VerifyCode = "password" });
            config.ServiceAccounts.Add("556", new MDWSConnection() { SiteID = "556", AccessCode = "medred3", VerifyCode = "password" });
            config.ServiceAccounts.Add("557", new MDWSConnection() { SiteID = "557", AccessCode = "medred3", VerifyCode = "password" });

            config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password";
            config.Caldav_Source = new Shared.Model.Config.Calendar.CalendarConfiguration()
            {
                BaseCalendarUri = new Uri("http://127.0.0.1:8080/ucaldav/user/mtwain/"),
                UserName = "mtwain",
                Password = "bedework"
            };

            return config;
        }

    }
}
