﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MedRed.Services.Utils;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Shared.Model;

namespace MedRed.Services.Tests
{
    internal class Utils
    {
        public static Site GetExistingSiteforVistaCode(Factory factory, string vistaSiteId)
        {
            var site = factory.GetSiteService().GetFromVistaSiteId(vistaSiteId);
            return site;
        }

        public static Site CreateAndSaveSite()
        {
            var site = new Site() { Name = "Patient test site", VistaSiteId = "555" };
            using (var dbSession = DataAccess.DataAccess.OpenSession())
            {
                dbSession.Save(site);
            }

            return site;
        }

        public static Facility CreateAndSaveFacility(Site site)
        {
            Facility facility = new Facility() { Name = "Facility 1", Site = site };
            using (var dbSession = DataAccess.DataAccess.OpenSession())
            {
                dbSession.Save(facility);
            }

            return facility;
        }

        public static Section CreateSection(Facility facility)
        {
            Section section = new Section() 
            {
                Name = "Section A", 
                DSSPrimaryStopCode = "368", 
                Facility = facility, 
                Active = true,
                Abbreviation = "SEC",
                Hours = "9-5",
                Location = "Norfolk, VA",                    
            };

            return section;
        }

        public static Section CreateAndSaveSection(Facility facility)
        {
            var section = CreateSection(facility);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            {
                dbSession.Save(section);
            }
            return section;
        }

        public static Section CreateAndSaveSectionWithAppTypes(Factory factory, string vistaSiteId, Facility facility)
        {
            var section = CreateSection(facility);

            var apptTypeCategores = factory.GetNationalSystemService().GetAppointmentTypeCategories(vistaSiteId);
            Assert.IsTrue(apptTypeCategores.Count > 0);

            var appType = new AppointmentType() { AppointmentTypeCategory = apptTypeCategores[0], Name = "Initial", Duration = 30 };
            section.AddAppointmentType(appType);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Save(section);
                transaction.Commit();
            }

            return section;
        }


        //public static Patient CreateAndSavePatientA()
        //{
        //    Patient patienta = new Patient()
        //    {
        //        ICN = "124",
        //        Person = new Person()
        //        {
        //            FirstName = "Henry",
        //            LastName = "Jackson",
        //            Sex = "M",
        //            DateOfBirth = new DateTime(1980, 1, 1),
        //            Email = "Jackson5@hotmail.com"
        //        }
        //    };

        //}

        public static Patient GetFirstPatientFromVista(Factory factory, string vistaSiteId)
        {
            var patSearchResults = factory.GetPatientService().Search(vistaSiteId, "");
            Assert.IsTrue(patSearchResults.Count > 0);

            var patSearchResult = patSearchResults.First();
            var patient = factory.GetPatientService().Get(patSearchResult);

            return patient;
        }

        public static Patient GetLastPatientFromVista(Factory factory, string vistaSiteId)
        {
            var patSearchResults = factory.GetPatientService().Search(vistaSiteId, "");
            Assert.IsTrue(patSearchResults.Count > 1);

            var patSearchResult = patSearchResults.Last();
            var patient = factory.GetPatientService().Get(patSearchResult);

            return patient;
        }

        public static Resource GetRealProviderResource(Factory factory, string vistaSiteId, Section section)
        {
            Site site = GetExistingSiteforVistaCode(factory, vistaSiteId);
            Assert.IsNotNull(site);
            var providers = factory.GetProviderService().GetAllForSite(site.Id);
            Assert.IsTrue(providers.Count > 0);
            var provider = providers.First();

            Resource resource = new Resource() { Name = "Dr. Smyth", Section = section, Type = ResourceType.Provider, FullfillingResourceId = provider.Id };

            SchedulingPolicy monday = new SchedulingPolicy() { DayOfWeek = 1, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref monday, new TimeSpan(8, 0, 0), new TimeSpan(10, 0, 0), 60);

            SchedulingPolicy friday = new SchedulingPolicy() { DayOfWeek = 5, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref friday, new TimeSpan(8, 0, 0), new TimeSpan(10, 0, 0), 60);

            SchedulingPolicy tuesday = new SchedulingPolicy() { DayOfWeek = 2, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref tuesday, new TimeSpan(8, 0, 0), new TimeSpan(9, 0, 0), 60);

            SchedulingPolicy thursday = new SchedulingPolicy() { DayOfWeek = 4, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref thursday, new TimeSpan(8, 0, 0), new TimeSpan(9, 0, 0), 60);

            resource.AddShedulingPolicy(monday);
            resource.AddShedulingPolicy(friday);
            resource.AddShedulingPolicy(tuesday);
            resource.AddShedulingPolicy(thursday);

            factory.GetResourceService().Add(resource);

            return resource;
        }

        public static Resource GetSecondRealProviderResource(Factory factory, string vistaSiteId, Section section)
        {
            Site site = GetExistingSiteforVistaCode(factory, vistaSiteId);
            Assert.IsNotNull(site);
            var providers = factory.GetProviderService().GetAllForSite(site.Id);
            Assert.IsTrue(providers.Count > 1);
            var provider = providers.ElementAt(1);

            Resource resource = new Resource() { Name = "Dr. Williams", Section = section, Type = ResourceType.Provider, FullfillingResourceId = provider.Id };

            SchedulingPolicy monday = new SchedulingPolicy() { DayOfWeek = 1, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref monday, new TimeSpan(8, 0, 0), new TimeSpan(10, 0, 0), 60);

            SchedulingPolicy friday = new SchedulingPolicy() { DayOfWeek = 5, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref friday, new TimeSpan(8, 0, 0), new TimeSpan(10, 0, 0), 60);

            SchedulingPolicy tuesday = new SchedulingPolicy() { DayOfWeek = 2, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref tuesday, new TimeSpan(8, 0, 0), new TimeSpan(9, 0, 0), 60);

            SchedulingPolicy thursday = new SchedulingPolicy() { DayOfWeek = 4, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref thursday, new TimeSpan(8, 0, 0), new TimeSpan(9, 0, 0), 60);

            resource.AddShedulingPolicy(monday);
            resource.AddShedulingPolicy(friday);
            resource.AddShedulingPolicy(tuesday);
            resource.AddShedulingPolicy(thursday);

            factory.GetResourceService().Add(resource);

            return resource;
        }

        public static Resource GetRoomResource(Factory factory, string vistaSiteId, Section section)
        {
            var resource = new Resource() { Name = "Room 12", Section = section, Type = ResourceType.Room };

            SchedulingPolicy monday = new SchedulingPolicy() { DayOfWeek = 1, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref monday, new TimeSpan(8, 0, 0), new TimeSpan(10, 0, 0), 60);

            SchedulingPolicy friday = new SchedulingPolicy() { DayOfWeek = 5, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref friday, new TimeSpan(8, 0, 0), new TimeSpan(10, 0, 0), 60);

            SchedulingPolicy tuesday = new SchedulingPolicy() { DayOfWeek = 2, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref tuesday, new TimeSpan(8, 0, 0), new TimeSpan(9, 0, 0), 60);

            SchedulingPolicy thursday = new SchedulingPolicy() { DayOfWeek = 4, StartEffectDate = new DateTime(2013, 1, 1), Priority = 1 };
            SchedulingHelper.AddSlotsToPolicy(ref thursday, new TimeSpan(8, 0, 0), new TimeSpan(9, 0, 0), 60);

            resource.AddShedulingPolicy(monday);
            resource.AddShedulingPolicy(friday);
            resource.AddShedulingPolicy(tuesday);
            resource.AddShedulingPolicy(thursday);

            factory.GetResourceService().Add(resource);

            return resource;
        }

    }
}
