﻿using MedRed.Services;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.DataAccess;
using NHibernate;
using MedRed.MDWSAccess;
using Shared.Model.Config.MDWS;
using System.Collections.Generic;
using Shared.Model;
using KellermanSoftware.CompareNetObjects;

namespace MedRed.Services.Tests
{
    [TestClass()]
    public class SiteServiceTest
    {   
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {
            MDWSConfiguration config = ConnectionHelper.GetTestingConfig();
//            MDWSConnection connection = ConnectionHelper.GetConnectionFor("100");
            var factory = Factory.GetFactory(config);

            TestContext.Properties["Factory"] = factory;
        }

        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        [TestMethod()]
        public void getAllSitesTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetSiteService();

            Assert.IsNotNull(service);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            {
                Site[] sitesArray = { new Site() { VistaSiteId="500", Name="Test Site 1" },
                                  new Site() {VistaSiteId = "501", Name = "Test Site 2"}};
                dbSession.Save(sitesArray[0]);
                dbSession.Save(sitesArray[1]);

                var sites = service.Get();
                var sitesList = new List<Site>(sites);

                Assert.IsTrue(sitesList.Count >= 2);
                Assert.IsTrue(sitesList.Exists(s => s.Name == "Test Site 1"));
                Assert.IsTrue(sitesList.Exists(s => s.Name == "Test Site 2"));

                dbSession.Delete(sitesArray[0]);
                dbSession.Delete(sitesArray[1]);
            }
        }

        [TestMethod()]
        public void getSiteTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetSiteService();

            Assert.IsNotNull(service);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            {
                Site[] sitesArray = { new Site() { VistaSiteId = "502", Name = "Test Site 3" } };
                dbSession.Save(sitesArray[0]);

                int siteId = sitesArray[0].Id;

                Assert.IsTrue(siteId != 0);

                var site = service.Get(siteId);

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(site, sitesArray[0]), compareObjects.DifferencesString);

                dbSession.Delete(sitesArray[0]);
            }
        }

        [TestMethod()]
        public void addSiteTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetSiteService();

            Assert.IsNotNull(service);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            {
                Site[] sitesArray = { new Site() { VistaSiteId = "503", Name = "Test Site 4" } };

                Assert.IsTrue(sitesArray[0].Id == 0);
                var site = service.Add(sitesArray[0]);

                int siteId = site.Id;

                Assert.IsTrue(siteId != 0);

                var retrievedSite = service.Get(siteId);

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(retrievedSite, sitesArray[0]), compareObjects.DifferencesString);

                dbSession.Delete(sitesArray[0]);
            }
        }
    }
}
