﻿using MedRed.Services;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.DataAccess;
using NHibernate;
using MedRed.MDWSAccess;
using Shared.Model.Config.MDWS;
using System.Collections.Generic;
using Shared.Model;
using KellermanSoftware.CompareNetObjects;

namespace MedRed.Services.Tests
{
    [TestClass()]
    public class ProviderServiceTest
    {   
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        [ClassInitialize()]
        public static void MyClassInitialize(TestContext testContext)
        {
            log4net.Config.XmlConfigurator.Configure();
        }
        
        //Use ClassCleanup to run code after all tests in a class have run
        [ClassCleanup()]
        public static void MyClassCleanup()
        {
        }
        
        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {
            MDWSConfiguration config = ConnectionHelper.GetTestingConfig();
//            MDWSConnection connection = ConnectionHelper.GetConnectionFor("100");
            var factory = Factory.GetFactory(config);

            TestContext.Properties["Factory"] = factory;
        }
        
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        [TestMethod()]
        public void getAllProviderTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetProviderService();

            Assert.IsNotNull(service);

                 Provider[] array = {new Provider() { NPI = "123", Person = new Person() { FirstName = "Bob", LastName = "Hope", Sex = "M", 
                     DateOfBirth = new DateTime(1970, 1,1), Email="BobHope@hotmail.com"}}, 
                     new Provider() { NPI = "124", Person = new Person() { FirstName = "Henry", LastName = "Jackson", Sex = "M", 
                     DateOfBirth = new DateTime(1980, 1,1), Email="Jackson5@hotmail.com"}}
                                   };

            Site site = new Site() { VistaSiteId = "502", Name = "Provider Test 2" };

            array[0].AddProviderSite("502", "123");
            array[1].AddProviderSite("502", "456");

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction()) 
            {
                dbSession.Save(site);
                dbSession.Save(array[0]);
                dbSession.Save(array[1]);
                transaction.Commit();
            }

            var providers = service.GetAllForSite(site.Id);
            var resourceList = new List<Provider>(providers);

            Assert.IsTrue(resourceList.Count >= 2);
            Assert.IsTrue(resourceList.Exists(s => s.Person.LastName == "Hope"));
            Assert.IsTrue(resourceList.Exists(s => s.Person.LastName == "Jackson"));

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Delete(array[0]);
                dbSession.Delete(array[1]);
                dbSession.Delete(site);

                transaction.Commit();
            }
        }

        [TestMethod()]
        [ExpectedException(typeof(ArgumentException))]
        public void getAllProviderInvalidSiteTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetProviderService();

            Assert.IsNotNull(service);

            Provider[] array = {new Provider() { NPI = "123", Person = new Person() { FirstName = "Bob", LastName = "Hope", Sex = "M", 
                     DateOfBirth = new DateTime(1970, 1,1), Email="BobHope@hotmail.com"}}, 
                     new Provider() { NPI = "124", Person = new Person() { FirstName = "Henry", LastName = "Jackson", Sex = "M", 
                     DateOfBirth = new DateTime(1980, 1,1), Email="Jackson5@hotmail.com"}}
                                   };

            var providers = service.GetAllForSite(400);
            var resourceList = new List<Provider>(providers);
        }



        [TestMethod()]
        public void getProviderTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetProviderService();

            Assert.IsNotNull(service);

            Provider[] array = {new Provider() { NPI = "123", Person = new Person() { FirstName = "Bob", LastName = "Hope", Sex = "M", 
                     DateOfBirth = new DateTime(1970, 1,1), Email="BobHope@hotmail.com"}}, 
                     new Provider() { NPI = "124", Person = new Person() { FirstName = "Henry", LastName = "Jackson", Sex = "M", 
                     DateOfBirth = new DateTime(1980, 1,1), Email="Jackson5@hotmail.com"}}
                                   };

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {

                dbSession.Save(array[0]);
                dbSession.Save(array[1]);
                transaction.Commit();
            }
            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                int providerId = array[0].Id;
                Assert.IsTrue(providerId != 0);

                var retrievedProvider = service.Get(providerId);

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(retrievedProvider, array[0]), compareObjects.DifferencesString);

                dbSession.Delete(array[0]);
                dbSession.Delete(array[1]);

                transaction.Commit();
            }
        }

        [TestMethod()]
        public void addProviderTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetProviderService();

            Assert.IsNotNull(service);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                Provider[] array = {new Provider() { NPI = "123", Person = new Person() { FirstName = "Bob", LastName = "Hope", Sex = "M", 
                     DateOfBirth = new DateTime(1970, 1,1), Email="BobHope@hotmail.com"}}, 
                     new Provider() { NPI = "124", Person = new Person() { FirstName = "Henry", LastName = "Jackson", Sex = "M", 
                     DateOfBirth = new DateTime(1980, 1,1), Email="Jackson5@hotmail.com"}}
                                   };

                Assert.IsTrue(array[0].Id == 0);

                var provider = service.Add(array[0]);
                int providerId = provider.Id;

                var retrievedProvider = service.Get(providerId);

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(retrievedProvider, array[0]), compareObjects.DifferencesString);

                dbSession.Delete(array[0]);
                dbSession.Delete(array[1]);
                transaction.Commit();
            }
        }

        [TestMethod()]
        public void addProviderSiteTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetProviderService();

            Assert.IsNotNull(service);

            int providerId;

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                Provider provider = new Provider()
                {
                    NPI = "123",
                    Person = new Person()
                    {
                        FirstName = "Bob",
                        LastName = "Hope",
                        Sex = "M",
                        DateOfBirth = new DateTime(1970, 1, 1),
                        Email = "BobHope@hotmail.com"
                    }
                };

                var addedProvider = service.Add(provider);
                providerId = provider.Id;
                transaction.Commit();
            }

            var retrievedProvider = service.Get(providerId);

            retrievedProvider.AddProviderSite("555", "1234");

            service.Update(retrievedProvider);

            var updatedProvider = service.Get(providerId);

            Assert.AreEqual(1, updatedProvider.ProviderSites.Count);

            string duz = updatedProvider.GetDUZForVistASite("555");
            Assert.AreEqual("1234", duz);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Delete(updatedProvider);
                transaction.Commit();
            }
        }
    }
}
