using MedRed.Services.ServiceImpl;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using Shared.Model;
using System.Collections.Generic;
using Shared.Model.Config.MDWS;
using KellermanSoftware.CompareNetObjects;

namespace MedRed.Services.Tests
{
    
    
    /// <summary>
    ///This is a test class for PatientServiceTest and is intended
    ///to contain all PatientServiceTest Unit Tests
    ///</summary>
    [TestClass()]
    public class PatientServiceTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {
            MDWSConfiguration config = ConnectionHelper.GetTestingConfig();
            var factory = Factory.GetFactory(config);

            TestContext.Properties["Factory"] = factory;

            // does Site exist? If so, add it
            var site = factory.GetSiteService().GetFromVistaSiteId("555");
            Assert.IsNotNull(site);
            //if (site == null)
            //{
            //    factory.GetSiteService().Add(new Site() { Name = "Patient test site", VistaSiteId = "555" });
            //}
//          factory.GetSiteService().Add(new Site() { Name = "Patient test site", VistaSiteId = "556" });

            var hierarchy = (log4net.Repository.Hierarchy.Hierarchy)log4net.LogManager.GetRepository();
            var logger = (log4net.Repository.Hierarchy.Logger)hierarchy.GetLogger("NHibernate.SQL");
            logger.AddAppender(new log4net.Appender.TraceAppender { Layout = new log4net.Layout.SimpleLayout() });
            hierarchy.Configured = true;

        }
        //Use TestCleanup to run code after each test has run
        [TestCleanup()]
        public void MyTestCleanup()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var sites = factory.GetSiteService().Get();

            //foreach (var site in sites)
            //{
            //    if (site.Name == "Patient test site")
            //        factory.GetSiteService().Delete(site.Id);
            //}

        }
        
        #endregion


        [TestMethod()]
        public void getAllPatientTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            Assert.IsNotNull(service);

            Patient[] array = {new Patient() { ICN = "123", Person = new Person() { FirstName = "Bob", LastName = "Hope", Sex = "M", 
                     DateOfBirth = new DateTime(1970, 1,1), Email="BobHope@hotmail.com"}}, 
                     new Patient() { ICN = "124", Person = new Person() { FirstName = "Henry", LastName = "Jackson", Sex = "M", 
                     DateOfBirth = new DateTime(1980, 1,1), Email="Jackson5@hotmail.com"}}
                                   };

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Save(array[0]);
                dbSession.Save(array[1]);
                transaction.Commit();
            }

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                var patients = service.Get();
                var patientList = new List<Patient>(patients);

                Assert.IsTrue(patientList.Count >= 2);
                Assert.IsTrue(patientList.Exists(s => s.Person.LastName == "Hope"));
                Assert.IsTrue(patientList.Exists(s => s.Person.LastName == "Jackson"));

                dbSession.Delete(array[0]);
                dbSession.Delete(array[1]);

                transaction.Commit();
            }
        }

        [TestMethod()]
        public void getPatientTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            Assert.IsNotNull(service);

            Patient[] array = {new Patient() { ICN = "123", Person = new Person() { FirstName = "Bob", LastName = "Hope", Sex = "M", 
                     DateOfBirth = new DateTime(1970, 1,1), Email="BobHope@hotmail.com"}}, 
                     new Patient() { ICN = "124", Person = new Person() { FirstName = "Henry", LastName = "Jackson", Sex = "M", 
                     DateOfBirth = new DateTime(1980, 1,1), Email="Jackson5@hotmail.com"}}
                                   };

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {

                dbSession.Save(array[0]);
                dbSession.Save(array[1]);
                transaction.Commit();
            }
            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                int patientId = array[0].Id;
                Assert.IsTrue(patientId != 0);

                var retrievedPatient = service.Get(patientId);

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(retrievedPatient, array[0]), compareObjects.DifferencesString);

                dbSession.Delete(array[0]);
                dbSession.Delete(array[1]);

                transaction.Commit();
            }
        }

        [TestMethod()]
        public void addPatientTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            Assert.IsNotNull(service);

            SpecialNeedType snType = new SpecialNeedType() { Name = "Needs Wheelchair" };
            PatientPreferenceType ppType = new PatientPreferenceType() { Name = "Morning Appointments" };
           
            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {

                dbSession.Save(snType);
                dbSession.Save(ppType);
                transaction.Commit();
            }

            Patient patientRec = new Patient()
            {
                ICN = "123",
                Person = new Person()
                {
                    FirstName = "Bob",
                    LastName = "Hope",
                    Sex = "M",
                    DateOfBirth = new DateTime(1970, 1, 1),
                    Email = "BobHope@hotmail.com"
                }
            };
                
            Assert.IsTrue(patientRec.Id == 0);

            patientRec.AddSpecialNeed(snType);
            patientRec.AddPatientPreference(ppType);

            var patient = service.Add(patientRec);
            int patientId = patient.Id;

            var retrievedPatient = service.Get(patientId);

            CompareObjects compareObjects = new CompareObjects();
            Assert.IsTrue(compareObjects.Compare(retrievedPatient, patientRec), compareObjects.DifferencesString);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Delete(patientRec);
                dbSession.Delete(snType);
                dbSession.Delete(ppType);
                transaction.Commit();
            }
        }

        [TestMethod()]
        public void addPatientSiteTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            Assert.IsNotNull(service);

            Patient patientRec = new Patient()
            {
                ICN = "123",
                Person = new Person()
                {
                    FirstName = "Bob",
                    LastName = "Hope",
                    Sex = "M",
                    DateOfBirth = new DateTime(1970, 1, 1),
                    Email = "BobHope@hotmail.com"
                }
            };
                
            Assert.IsTrue(patientRec.Id == 0);


            var patient = service.Add(patientRec);
            int patientId = patient.Id;

            var retrievedPatient = service.Get(patientId);

            retrievedPatient.AddPatientSite("555", "5678");
            //retrievedPatient.PatientSites.Add(new PatientSite() { VistaSiteId = "555", DFN = "5678" });
            service.Update(retrievedPatient);

            var updatedPatient = service.Get(patientId);

            Assert.AreEqual(1, updatedPatient.PatientSites.Count);

            string duz = updatedPatient.GetDFNForVistASite("555");
            Assert.AreEqual("5678", duz);
            
            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Delete(patientRec);
                transaction.Commit();
            }
        }

        /// <summary>
        ///A test for Search
        ///</summary>
        [TestMethod()]
        public void SearchPatientTest()
        {
//            MDWSConfiguration config = ConnectionHelper.GetDefaultConfig();
//            var factory = Factory.GetFactory(config);
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            var patients = service.Search("555", "");

            Assert.IsNotNull(patients);
        }

        [TestMethod()]
        public void SearchPatient_BlankTest()
        {
            //            MDWSConfiguration config = ConnectionHelper.GetDefaultConfig();
            //            var factory = Factory.GetFactory(config);
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            var patients = service.Search("555", "");
            
            Assert.IsNotNull(patients);

            Assert.IsTrue(patients.Count > 0);
        }

        [TestMethod()]
        public void SearchPatient_OneLetterTest()
        {
            //            MDWSConfiguration config = ConnectionHelper.GetDefaultConfig();
            //            var factory = Factory.GetFactory(config);
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            var patients = service.Search("555", "n");

            Assert.IsNotNull(patients);
            foreach (var pat in patients)
            {
                Assert.IsTrue(pat.LastName.ToUpper().StartsWith("N"));
            }
        }

        [TestMethod()]
        public void Search_And_GetNewPatientTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            //MDWSConfiguration config = ConnectionHelper.GetDefaultConfig();
            //config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password";
            //Factory factory = Factory.GetFactory(config);
            var service = factory.GetPatientService();

            //// can we load the patient in and then delete to make sure they are't here?
            var patient = Utils.GetLastPatientFromVista(factory, "555");
            //service.Delete(patient.Id);

            var allSchedulingPatients = service.Get();
            int firstCount = allSchedulingPatients.Count;

//            patient = Utils.GetLastPatientFromVista(factory, "555");

            Assert.IsNotNull(patient);

            var allSchedulingPatients2 = service.Get();
            int secondCount = allSchedulingPatients2.Count;

            // can't reliabled test this, so giving up
//            Assert.AreEqual(firstCount + 1, secondCount);
//           service.Delete(patient.Id);
        }

        [TestMethod()]
        public void Search_And_GetExistingPatientTest()
        {
            //MDWSConfiguration config = ConnectionHelper.GetDefaultConfig();
            //config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password";
            //var factory = Factory.GetFactory(config);
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();

            var patients = service.Search("555", "");
            Assert.IsTrue(patients.Count > 0);
            var firstPatient = patients[0];
            var newPatient = service.Get(firstPatient);
            Assert.IsNotNull(newPatient);

            var allSchedulingPatients = service.Get();
            int firstCount = allSchedulingPatients.Count;

            // search and load the patient again - nothing new should be added
            patients = service.Search("555", "");
            Assert.IsTrue(patients.Count > 0);
            firstPatient = patients[0];
            newPatient = service.Get(firstPatient);
            Assert.IsNotNull(newPatient);

            var allSchedulingPatients2 = service.Get();
            int secondCount = allSchedulingPatients.Count;

            Assert.AreEqual(firstCount, secondCount);
//            service.Delete(newPatient.Id);
        }

        [TestMethod()]
        public void GetExistingPatientDetailsTest()
        {
            //MDWSConfiguration config = ConnectionHelper.GetDefaultConfig();
            //config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password";
            //var factory = Factory.GetFactory(config);
            var factory = TestContext.Properties["Factory"] as Factory;

            var service = factory.GetPatientService();

            var patients = service.Search("555", "");
            Assert.IsTrue(patients.Count > 0);
            var firstPatient = patients[0];
            var newPatient = service.Get(firstPatient);
            Assert.IsNotNull(newPatient);

            var moreDetailed = service.GetFullDetails("555", newPatient.Id);
            // how to test?

//            service.Delete(newPatient.Id);
        }

    }
}
