﻿using MedRed.Services;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.MDWSAccess;
using Shared.Model;
using MedRed.Services.Utils;

namespace MedRed.Services.Tests
{
    
    
    /// <summary>
    ///This is a test class for ServicesTest and is intended
    ///to contain all ServicesTest Unit Tests
    ///</summary>
    [TestClass()]
    public class PasswordHelperTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        [TestMethod()]
        public void CreatePasswordTest()
        {
            User user = new User();
            PasswordHelper.SetUserPassword(ref user, "Test Password");

            Assert.IsNotNull(user.Password);
            Assert.IsNotNull(user.Salt);
            Assert.AreNotEqual(user.Password, "Test Password");
        }

        [TestMethod()]
        public void CreateUniquePasswordForUsersTest()
        {
            User userA = new User();
            User userB = new User();

            PasswordHelper.SetUserPassword(ref userA, "Test Password");
            PasswordHelper.SetUserPassword(ref userB, "Test Password");

            Assert.AreNotEqual(userA.Password, userB.Password);

        }
    }
}
