using MedRed.Services;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.DataAccess;
using NHibernate;
using MedRed.MDWSAccess;
using Shared.Model.Config.MDWS;
using System.Collections.Generic;
using Shared.Model;
using KellermanSoftware.CompareNetObjects;

namespace MedRed.Services.Tests
{
    [TestClass()]
    public class ImportServiceTest
    {   
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            var config = new MDWSConfiguration();
            config.BaseMDWS_Url = "http://127.0.0.1/MDWS2/";

            config.DataSources.Add("555", new DataSource { SiteID = "555", Server = "127.0.0.1", Port = "9200" });
            config.DataSources.Add("556", new DataSource { SiteID = "556", Server = "127.0.0.1", Port = "9200" });
            config.DataSources.Add("557", new DataSource { SiteID = "557", Server = "127.0.0.1", Port = "9200" });
            config.ServiceAccounts.Add("555", new MDWSConnection() { SiteID = "555", AccessCode = "medred3", VerifyCode = "password" });
            config.ServiceAccounts.Add("556", new MDWSConnection() { SiteID = "556", AccessCode = "medred3", VerifyCode = "password" });
            config.ServiceAccounts.Add("557", new MDWSConnection() { SiteID = "557", AccessCode = "medred3", VerifyCode = "password" });

            config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password";
            config.Caldav_Source = new Shared.Model.Config.Calendar.CalendarConfiguration()
            {
                BaseCalendarUri = new Uri("http://127.0.0.1:8080/ucaldav/user/mtwain/"),
                UserName = "mtwain",
                Password = "bedework"
            };

//            var connection = new MDWSConnection() { SiteID = "555", AccessCode = "medred1", VerifyCode = "password" };

            var factory = Factory.GetFactory(config);

            TestContext.Properties["Factory"] = factory;

            var hierarchy = (log4net.Repository.Hierarchy.Hierarchy)log4net.LogManager.GetRepository();
            var logger = (log4net.Repository.Hierarchy.Logger)hierarchy.GetLogger("NHibernate.SQL");
            logger.AddAppender(new log4net.Appender.TraceAppender { Layout = new log4net.Layout.SimpleLayout() });
            hierarchy.Configured = true;
        }
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        [TestMethod()]
        public void ImportTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetImportService();
            Assert.IsNotNull(service);

            service.ImportSite("555");
        }

        [TestMethod()]
        public void ImportProvidersTest()
        {
//            throw new NotImplementedException();

            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetImportService();
            Assert.IsNotNull(service);

            service.ImportProviders("557");
        }

        [TestMethod()]
        public void ValidateConnectionTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetImportService();
            Assert.IsNotNull(service);

            Assert.IsTrue(service.ValidateServiceAccount("555"));
        }

        [TestMethod()]
        public void RunCheckAndUpdateTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetImportService();
            Assert.IsNotNull(service);

            Assert.IsTrue(service.CheckAndUpdate());
        }

    }
}
