﻿using MedRed.Services;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.MDWSAccess;
using Shared.Model.Config.MDWS;

namespace MedRed.Services.Tests
{
    [TestClass()]
    public class FactoryTest
    {   
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {
            MDWSConfiguration config = ConnectionHelper.GetTestingConfig();
//            MDWSConnection connection = ConnectionHelper.GetConnectionFor("100");
            var factory = Factory.GetFactory(config);

            TestContext.Properties["Factory"] = factory;
        }

        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        [TestMethod()]
        public void GetMDWSConnection_SuccessTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetAccountService();
            Assert.IsNotNull(factory.GetVistaServiceAccountForSite("555"));
        }

        [TestMethod()]
        [ExpectedException(typeof(ArgumentException))]
        public void GetMDWSConnection_FailTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetAccountService();
            Assert.IsNull(factory.GetVistaServiceAccountForSite("987"));

        }

        [TestMethod()]
        public void getAccountServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetAccountService();
        }

        [TestMethod()]
        public void getAppointmentServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetAppointmentService();
        }

        [TestMethod()]
        public void getEquipmentServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetEquipmentService();
        }

        [TestMethod()]
        public void getFacilityServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetFacilityService();
        }

        [TestMethod()]
        public void getImportServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetImportService();
        }

        [TestMethod()]
        public void getPatientServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetPatientService();
        }

        [TestMethod()]
        public void getProviderServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetProviderService();
        }

        [TestMethod()]
        public void getResourceServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetResourceService();
        }

        [TestMethod()]
        public void getRoomServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetRoomService();
        }

        [TestMethod()]
        public void getSectionServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetSectionService();
        }

        [TestMethod()]
        public void getSiteServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetSiteService();
        }

        [TestMethod()]
        public void getHCSServiceTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetNationalSystemService();
        }

    }
}
