﻿using MedRed.Services;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.DataAccess;
using NHibernate;
using MedRed.MDWSAccess;
using Shared.Model.Config.MDWS;
using System.Collections.Generic;
using Shared.Model;
using KellermanSoftware.CompareNetObjects;

namespace MedRed.Services.Tests
{
    [TestClass()]
    public class EquipmentServiceTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        [ClassInitialize()]
        public static void MyClassInitialize(TestContext testContext)
        {
            log4net.Config.XmlConfigurator.Configure();
        }

        //Use ClassCleanup to run code after all tests in a class have run
        [ClassCleanup()]
        public static void MyClassCleanup()
        {
        }

        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {
            MDWSConfiguration config = ConnectionHelper.GetTestingConfig();
            var factory = Factory.GetFactory(config);

            TestContext.Properties["Factory"] = factory;
        }

        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        [TestMethod()]
        public void getAllEquipmentTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetEquipmentService();

            Assert.IsNotNull(service);

            Site site = new Site() { VistaSiteId = "501", Name = "Equipt Site 2" };

            Equipment[] array = {new Equipment() { Name="3rd Floor EKG", Type = "EKG", Site = site},
                           new Equipment() { Name="Main Hospital MRI", Type = "MRI", Site = site},
                          new Equipment() { Name="Rehabilitation Center Treadmill", Type = "Treadmill", Site = site},
                            };

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Save(site);
                dbSession.Save(array[0]);
                dbSession.Save(array[1]);
                dbSession.Save(array[2]);
                transaction.Commit();
            }

            var equipment = service.GetAllForSite(site.Id);
            var equipmentList = new List<Equipment>(equipment);

            Assert.IsTrue(equipmentList.Count >= 3);
            Assert.IsTrue(equipmentList.Exists(s => s.Name == "3rd Floor EKG"));
            Assert.IsTrue(equipmentList.Exists(s => s.Name == "Rehabilitation Center Treadmill"));

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {

                dbSession.Delete(array[0]);
                dbSession.Delete(array[1]);
                dbSession.Delete(array[2]);
                dbSession.Delete(site);
                transaction.Commit();
            }
        }

        [TestMethod()]
        public void getEquipmentTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetEquipmentService();

            Assert.IsNotNull(service);

            Equipment[] array = {new Equipment() { Name="3rd Floor EKG", Type = "EKG"},
                           new Equipment() { Name="Main Hospital MRI", Type = "MRI"},
                          new Equipment() { Name="Rehabilitation Center Treadmill", Type = "Treadmill"},
                            };


            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {
                dbSession.Save(array[0]);
                dbSession.Save(array[1]);
                dbSession.Save(array[2]);
                transaction.Commit();
            }
            int equipmentId = array[0].Id;
            Assert.IsTrue(equipmentId != 0);

            var retrievedEquipment = service.Get(equipmentId);

            CompareObjects compareObjects = new CompareObjects();
            Assert.IsTrue(compareObjects.Compare(retrievedEquipment, array[0]), compareObjects.DifferencesString);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {

                dbSession.Delete(array[0]);
                dbSession.Delete(array[1]);
                dbSession.Delete(array[2]);
                transaction.Commit();
            }
        }

        [TestMethod()]
        public void addEquipmentTest()
        {
            var factory = TestContext.Properties["Factory"] as Factory;
            var service = factory.GetEquipmentService();

            Assert.IsNotNull(service);

            Equipment[] array = {new Equipment() { Name="3rd Floor EKG", Type = "EKG"},
                           new Equipment() { Name="Main Hospital MRI", Type = "MRI"},
                          new Equipment() { Name="Rehabilitation Center Treadmill", Type = "Treadmill"},
                            };

            Assert.IsTrue(array[0].Id == 0);

            var equipment = service.Add(array[0]);
            int equipmentId = equipment.Id;

            var retrievedEquipment = service.Get(equipmentId);

            CompareObjects compareObjects = new CompareObjects();
            Assert.IsTrue(compareObjects.Compare(retrievedEquipment, array[0]), compareObjects.DifferencesString);

            using (var dbSession = DataAccess.DataAccess.OpenSession())
            using (var transaction = dbSession.BeginTransaction())
            {

                dbSession.Delete(array[0]);
                transaction.Commit();
            }
        }
    }
}
