﻿using MedRed.Services;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.DataAccess;
using NHibernate;
using MedRed.MDWSAccess;
using Shared.Model.Config.MDWS;
using System.Collections.Generic;
using Shared.Model;
using KellermanSoftware.CompareNetObjects;
using MedRed.Services.Utils;

namespace MedRed.Services.Tests
{
    [TestClass()]
    public class CommunicationHelperTest
    {   
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
        }

        //Use TestCleanup to run code after each test has run
        [TestCleanup()]
        public void MyTestCleanup()
        {
        }

        #endregion


        [TestMethod()]
        public void AddressToStringTest()
        {
            Address address = new Address(){ Street1="1001 Main Street", Street2 = @"C\O Randy Newman", City = "Hemington", State= "DE", Zip = "12345-6789"};

            var expected = 
                @"1001 Main Street
C\O Randy Newman
Hemington, DE 12345-6789
";

            var actual = CommunicationHelper.AddressToString(address);

            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void AddressToString2Test()
        {
            Address address = new Address(){ Street1="123 Jones Circle", City = "Hemington", State= "DE", Zip = "12345-6789"};

            var expected =
                @"123 Jones Circle
Hemington, DE 12345-6789
";

            var actual = CommunicationHelper.AddressToString(address);

            Assert.AreEqual(expected, actual);

        }

    }
}
