using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;

// comment
namespace MedRed.MDWSAccess
{
    public class Utils
    {
        public static List<string> getStringList(SchedulingService.TaggedText taggedText)
        {
            List<String> list = new List<string>();
            if (taggedText != null && taggedText.textArray != null && taggedText.textArray.Length > 0)
            {
                foreach (var item in taggedText.textArray)
                {
                    list.Add(item);
                }
            }
            return list;
        }

        public static List<string> getStringList(EmrSvc.TaggedText taggedText)
        {
            List<String> list = new List<string>();
            if (taggedText != null && taggedText.textArray != null && taggedText.textArray.Length > 0)
            {
                foreach (var item in taggedText.textArray)
                {
                    list.Add(item);
                }
            }
            return list;
        }

        public static List<string> getStringList(QuerySvc.TaggedText taggedText)
        {
            List<String> list = new List<string>();
            if (taggedText != null && taggedText.textArray != null && taggedText.textArray.Length > 0)
            {
                foreach (var item in taggedText.textArray)
                {
                    list.Add(item);
                }
            }
            return list;
        }

        public static string ReformatCPRSDate(string p_dateString)
        {
            DateTime date = ParseCPRSDate(p_dateString);
            string newFormat = date.ToString("MMM dd, yyyy HH:mm");
            return newFormat;
        }

        public static DateTime ParseCPRSDate(string p_dateString)
        {
            System.Globalization.CultureInfo provider = System.Globalization.CultureInfo.InvariantCulture;

            //20110125.090000
            //        Date is formatted 20111118 and should be Nov 18, 2011
            DateTime date;
            try
            {
                date = DateTime.ParseExact(p_dateString, @"yyyyMMdd\.HHmmss", provider);

            }
            catch (FormatException)
            {
//                Logger.Log(string.Format(RX_Others._0_is_not_in_the_correct_format, p_dateString));
                return DateTime.MinValue;
            }
            return date;
        }

        // format of name is   <name>AA-BELNU,NLENL LKR</name> 
        public static bool SplitName(string p_name, out string p_first, out string p_middle, out string p_last)
        {
            p_first = p_middle = p_last = string.Empty;

            // get middle name at the end
            string[] nameSplit = p_name.Split(' ');
            if (nameSplit.Length > 1)
            {
                p_middle = nameSplit[1].Trim();
            }
            if (nameSplit.Length > 0)
            {
                // get first and last name
                nameSplit = nameSplit[0].Split(',');
                if (nameSplit.Length > 1)
                {
                    p_first = nameSplit[1].Trim();

                }
                if (nameSplit.Length > 0)
                {
                    p_last = nameSplit[0].Trim();
                }
            }
            return true;
        }

        public static bool HasFaultMessage(MedRed.MDWSAccess.EmrSvc.AbstractTO val)
        {
            return (val.fault != null && !String.IsNullOrEmpty(val.fault.message));
        }

        public static bool HasFaultMessage(MedRed.MDWSAccess.SchedulingService.AbstractTO val)
        {
            return (val.fault != null && !String.IsNullOrEmpty(val.fault.message));
        }

        public static bool HasFaultMessage(MedRed.MDWSAccess.QuerySvc.AbstractTO val)
        {
            return (val.fault != null && !String.IsNullOrEmpty(val.fault.message));
        }


        public static DateTime? FromMDWSDate(string mdwsDate)
        {
            if (!String.IsNullOrEmpty(mdwsDate))
            {
                string yearStr = mdwsDate.Substring(0, 3);
                string monthStr = mdwsDate.Substring(3, 2);
                string dayStr = mdwsDate.Substring(5, 2);

                int year, month, day;
                if (Int32.TryParse(yearStr, out year) && Int32.TryParse(monthStr, out month) && Int32.TryParse(dayStr, out day))
                {
                    DateTime date = new DateTime(year + 1700, month, day);
                    return date;
                }

                CultureInfo provider = CultureInfo.InvariantCulture;
                DateTime date2;
                if (DateTime.TryParseExact(mdwsDate, "MMM dd, yyyy", provider, DateTimeStyles.None, out date2))
                    return date2;
            }
            return null;
        }

        public static string ToMDWSDate(DateTime? datetime)
        {
            if (!datetime.HasValue)
            {
                return string.Empty;
            }
            string date = string.Format("{0}{1}{2}{3}{4}{5}",
                datetime.Value.Year-1700,
                datetime.Value.Month.ToString("00"),
                datetime.Value.Day.ToString("00"),
                datetime.Value.Hour.ToString("00"),
                datetime.Value.Minute.ToString("00"),
                datetime.Value.Second.ToString("00"));

            return date;
        }

        public static string ToMDWSDateTime(DateTime? datetime)
        {
            if (!datetime.HasValue)
            {
                return string.Empty;
            }
            string date = string.Format("{0}{1}{2}.{3}{4}{5}",
                datetime.Value.Year - 1700,
                datetime.Value.Month.ToString("00"),
                datetime.Value.Day.ToString("00"),
                datetime.Value.Hour.ToString("00"),
                datetime.Value.Minute.ToString("00"),
                datetime.Value.Second.ToString("00"));

            return date;
        }

        public static string ToMDWSAppointmentDateTime(DateTime? datetime)
        {
            if (!datetime.HasValue)
            {
                return string.Empty;
            }
            string date = string.Format("{0}{1}{2}.{3}{4}{5}",
                datetime.Value.Year - 1700,
                datetime.Value.Month.ToString("00"),
                datetime.Value.Day.ToString("00"),
                datetime.Value.Hour.ToString("00"),
                datetime.Value.Minute.ToString("00"),
                datetime.Value.Second.ToString("00"));

            // find where trailing zero's start, so we can remove them for Vista (WHY DO I HAVE TO DO THIS???)
            int lastIndex = date.Length-1;
            while (lastIndex >=0 && date[lastIndex] == '0')
            {
                lastIndex--;
            }
            if (lastIndex != date.Length - 1 && lastIndex > 0)
            {
                date = date.Substring(0, lastIndex+1);
            }

            return date;
        }

        //internal static bool? FromMDWSBoolean(string value)
        //{
        //    bool? val = null;
        //    if (String.IsNullOrEmpty(value))
        //        val = null;
        //    else if (String.Equals(value, "Y") || String.Equals(value, "Yes"))
        //        val = true;
        //    else if (String.Equals(value, "N") || String.Equals(value, "No"))
        //        val = false;

        //    return val;
        //}
    }
}
