﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Shared.Model;

namespace MedRed.MDWSAccess
{
    class ProviderFormatter
    {
        public static Provider CreateFromMDWSUser(EmrSvc.UserTO p_mdwsUser)
        {
            Provider provider = new Provider();
            provider.Person = new Person();

            try
            {
                string first, middle, last;
                Utils.SplitName(p_mdwsUser.name, out first, out middle, out last);

                provider.Person.FirstName = first;
                provider.Person.LastName = last;

                provider.Person.Phone = p_mdwsUser.phone;
                provider.Person.SSN = p_mdwsUser.SSN;
//                provider.Person.DUZ = p_mdwsUser.DUZ;
            }
            catch (Exception)
            {
                provider.Person.SSN = string.Empty;
//                Logger.Log(exp.StackTrace);
            }

            return provider;
        }
    }
}
