﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Shared.Model;

namespace MedRed.MDWSAccess
{
    partial class MDWSCalls
    {
        public string GetAppointmentStatus(string patId, string apptId)
        {
            string status = string.Empty;
            prepareEmrConnection();
            var pat = _EmrService.select(patId);

//            var appts = _EmrService.getAppointmentText(

            disconnectEmr();
            //prepareQueryConnection();
            //string status = string.Empty;

            //var result2 = _QueryService.ddrLister("2.98", "," + patId + ",", "@;.01", "P", "", "", "", "", "", "");
            //var result4 = _QueryService.read("," + patId + ","+apptId, "*", "2.98");
            //var result3 = _QueryService.read(apptId+ "," + patId + ",", "*", "2.98");

            //if (result2 != null && result2.count > 0)
            //{
            //    foreach (var result in result2.text)
            //    {
            //        string[] values = result2.text[0].Split('^');
            //        string vistaApptId = values[0];
            //        string vistaStatus = values[1];

            //        if (String.Equals(vistaApptId, apptId))
            //        {
            //            status = vistaStatus;
            //            break;
            //        }
            //    }
            //}

            //disconnectQuery();
            return status;
        }

        private void validateAppointment(Appointment appt, out string vistaClinicId, out string patientDFN)
        {
            prepareSchedulingConnection();
            Resource provider = appt.Resources.FirstOrDefault(r => r.Type == ResourceType.Provider);
            if (provider == null)
            {
                throw new ArgumentException("Appointment has no provider resource");
            }
            vistaClinicId = provider.VistaClinicIEN;
            if (String.IsNullOrEmpty(vistaClinicId))
            {
                throw new ArgumentException("Provider resource does not have a Vista Clinic ID: " + provider.Name);
            }

            Patient pat = appt.Patient;
            if (pat == null)
            {
                throw new ArgumentException("Appointment must have a Patient");
            }

            patientDFN = pat.GetDFNForVistASite(Connection.SiteID);
            if (String.IsNullOrEmpty(patientDFN))
            {
                throw new ArgumentException(string.Format("Patient {0} is not associated with site {1}", pat.Person.ToString(), Connection.SiteID));
            }


            disconnectScheduling();
        }

        public bool MakeAppointment(Appointment appt)
        {
            string clinicId, patDFN;
            prepareSchedulingConnection();
            validateAppointment(appt, out clinicId, out patDFN);

            DateTime apptTime = appt.Time;
            string timeZone = appt.Section.Facility.Site.TimeZoneId;
            if (String.IsNullOrEmpty(timeZone))
            {
                throw new ApplicationException("Appointment is being added to a site with an invalid time zone");
            }

            TimeZoneInfo tz = TimeZoneInfo.FindSystemTimeZoneById(timeZone);
            TimeSpan offset = tz.GetUtcOffset(apptTime);

            apptTime = apptTime.Add(offset);


            if (appt.AppointmentType == null)
            {
                throw new ApplicationException("Appointment doesn't have an appointment type");
            }

            if (appt.AppointmentType.AppointmentTypeCategory == null)
            {
                throw new ApplicationException("Appointment doesn't have a valid appointment type (Missing appointment type category)");
            }

            var apptTypeCode = appt.AppointmentType.AppointmentTypeCategory.VistaId;
            if (String.IsNullOrEmpty(apptTypeCode))
            {
                throw new ApplicationException("Appointment Type Category doesn't have a valid vistaID: ");
            }

            var patTO = _SchedulingService.select(patDFN);
            if (Utils.HasFaultMessage(patTO))
            {
                throw new ApplicationException("Error selecting patient before adding appointment: " + patTO.fault.message);
            }

            var apptTO = _SchedulingService.makeAppointment(clinicId, Utils.ToMDWSAppointmentDateTime(apptTime), "N", "", appt.Length.ToString(), apptTypeCode);
            
            if (Utils.HasFaultMessage(apptTO))
            {
                throw new ApplicationException("Error creating appointment: " + apptTO.fault.message);
            }

            if (apptTO != null)
            {
                appt.VistaId = apptTO.timestamp;
                return true;
            }
            return false;
        }

        public bool MakeUnscheduledAppointment(Appointment appt)
        {
            string clinicId, patDFN;
            prepareSchedulingConnection();
            validateAppointment(appt, out clinicId, out patDFN);

            DateTime apptTime = appt.Time;
            string timeZone = appt.Section.Facility.Site.TimeZoneId;
            if (String.IsNullOrEmpty(timeZone))
            {
                throw new ApplicationException("Appointment is being added to a site with an invalid time zone");
            }

            TimeZoneInfo tz = TimeZoneInfo.FindSystemTimeZoneById(timeZone);
            TimeSpan offset = tz.GetUtcOffset(apptTime);

            apptTime = apptTime.Add(offset);

            var apptTypeCode = appt.AppointmentType.AppointmentTypeCategory.VistaId;

            var patTO = _SchedulingService.select(patDFN);
            if (Utils.HasFaultMessage(patTO))
            {
                throw new ApplicationException("Error selecting patient before adding appointment: " + patTO.fault.message);
            }
            var apptTO = _SchedulingService.makeUnscheduledAppointment(clinicId, Utils.ToMDWSAppointmentDateTime(apptTime), "N", "");

            if (Utils.HasFaultMessage(apptTO))
            {
                throw new ApplicationException("Error creating appointment: " + apptTO.fault.message);
            }

            if (apptTO != null)
            {
                appt.VistaId = apptTO.timestamp;
                return true;
            }
            return false;
        }

        public bool CheckInAppointment(Appointment appt)
        {
            string clinicId, patDFN;
            prepareSchedulingConnection();
            validateAppointment(appt, out clinicId, out patDFN);

            var apptTypeCode = appt.AppointmentType.AppointmentTypeCategory.VistaId;

            var patTO = _SchedulingService.select(patDFN);
            if (Utils.HasFaultMessage(patTO))
            {
                throw new ApplicationException("Error selecting patient before checking in appointment: " + patTO.fault.message);
            }

            var apptTO = _SchedulingService.checkInAppointment(clinicId, appt.VistaId);

            if (Utils.HasFaultMessage(apptTO))
            {
                throw new ApplicationException("Error checking in appointment: " + apptTO.fault.message);
            }

            return false;
        }

        public bool CheckOutAppointment(Appointment appt)
        {
            string clinicId, patDFN;
            prepareSchedulingConnection();
            validateAppointment(appt, out clinicId, out patDFN);

            var apptTypeCode = appt.AppointmentType.AppointmentTypeCategory.VistaId;

            var patTO = _SchedulingService.select(patDFN);
            if (Utils.HasFaultMessage(patTO))
            {
                throw new ApplicationException("Error selecting patient before checking out appointment: " + patTO.fault.message);
            }

            var apptTO = _SchedulingService.checkOutAppointment(clinicId, appt.VistaId);

            if (Utils.HasFaultMessage(apptTO))
            {
                throw new ApplicationException("Error checking out appointment: " + apptTO.fault.message);
            }

            return false;
        }

        public bool NoShowAppointment(Appointment appt)
        {
            string clinicId, patDFN;
            prepareSchedulingConnection();
            validateAppointment(appt, out clinicId, out patDFN);

            var apptTypeCode = appt.AppointmentType.AppointmentTypeCategory.VistaId;

            var patTO = _SchedulingService.select(patDFN);
            if (Utils.HasFaultMessage(patTO))
            {
                throw new ApplicationException("Error selecting patient before no showing an appointment: " + patTO.fault.message);
            }

            var apptTO = _SchedulingService.noShowAppointment(clinicId, appt.VistaId);

            if (Utils.HasFaultMessage(apptTO))
            {
                throw new ApplicationException("Error no showing appointment: " + apptTO.fault.message);
            }

            return false;
        }

        public bool CancelAppointment(Appointment appt, string cancelType, string cancellationReason, string remarks)
        {
            string clinicId, patDFN;
            prepareSchedulingConnection();
            validateAppointment(appt, out clinicId, out patDFN);

//            var apptTypeCode = appt.AppointmentType.AppointmentTypeCategory.VistaId;

            var patTO = _SchedulingService.select(patDFN);
            if (Utils.HasFaultMessage(patTO))
            {
                throw new ApplicationException("Error selecting patient before cancelling an appointment: " + patTO.fault.message);
            }

            var apptTO = _SchedulingService.cancelAppointment(clinicId, appt.VistaId, cancelType, cancellationReason, remarks);

            if (Utils.HasFaultMessage(apptTO))
            {
                throw new ApplicationException("Error cancelling appointment: " + apptTO.fault.message);
            }

            return false;
        }
    }
}
