﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.MDWSAccess;
using System.Collections.Generic;
using MedRed.MDWSAccess.EmrSvc;
using MedRed.MDWSAccess.SchedulingService;

namespace MedRed.MDWSAccess.Tests
{
    
    
    /// <summary>
    ///This is a test class for UtilsTest and is intended
    ///to contain all UtilsTest Unit Tests
    ///</summary>
    [TestClass()]
    public class UtilsTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///A test for getStringList
        ///</summary>
        [TestMethod()]
        public void getStringListTest_Scheduling_Null()
        {
            MedRed.MDWSAccess.SchedulingService.TaggedText taggedText = null; // TODO: Initialize to an appropriate value
            List<string> expected = new List<string>();
            List<string> actual;
            actual = Utils.getStringList(taggedText);
            Assert.IsTrue(expected.Count == actual.Count);
            Assert.IsTrue(actual.Count == 0);
        }

        /// <summary>
        ///A test for getStringList
        ///</summary>
        [TestMethod()]
        public void getStringListTest_Emr_Null()
        {
            MedRed.MDWSAccess.EmrSvc.TaggedText taggedText = null; // TODO: Initialize to an appropriate value
            List<string> expected = new List<string>();
            List<string> actual;
            actual = Utils.getStringList(taggedText);
            Assert.IsTrue(expected.Count == actual.Count);
            Assert.IsTrue(actual.Count == 0);
        }

        /// <summary>
        ///A test for getStringList
        ///</summary>
        [TestMethod()]
        public void getStringListTest_Scheduling()
        {
            MedRed.MDWSAccess.SchedulingService.TaggedText taggedText = null; // TODO: Initialize to an appropriate value
            taggedText = new MedRed.MDWSAccess.SchedulingService.TaggedText();
            taggedText.textArray = new string[3];
            taggedText.textArray[0] = "test 1";
            taggedText.textArray[1] = "test 2";
            taggedText.textArray[2] = "test 3";
            List<string> expected = new List<string>() { "test 1", "test 2", "test 3" };
            List<string> actual;
            actual = Utils.getStringList(taggedText);
            Assert.IsTrue(expected.Count == actual.Count);
            for (int i=0; i < actual.Count; i++)
            {
                Assert.AreEqual(actual[i], expected[i]);
            }
        }

        /// <summary>
        ///A test for getStringList
        ///</summary>
        [TestMethod()]
        public void getStringListTest_Emr()
        {
            MedRed.MDWSAccess.EmrSvc.TaggedText taggedText = null; // TODO: Initialize to an appropriate value
            taggedText = new MedRed.MDWSAccess.EmrSvc.TaggedText();
            taggedText.textArray = new string[3];
            taggedText.textArray[0] = "test 4";
            taggedText.textArray[1] = "test 5";
            taggedText.textArray[2] = "test 6";
            List<string> expected = new List<string>() { "test 4", "test 5", "test 6" };
            List<string> actual;
            actual = Utils.getStringList(taggedText);
            Assert.IsTrue(expected.Count == actual.Count);
            for (int i=0; i < actual.Count; i++)
            {
                Assert.AreEqual(actual[i], expected[i]);
            }
        }


        /// <summary>
        ///A test for HasFaultMessage
        ///</summary>
        [TestMethod()]
        public void HasFaultMessage__Sch_TrueTest()
        {
            MedRed.MDWSAccess.SchedulingService.AbstractTO val = new MedRed.MDWSAccess.SchedulingService.AddressTO();
            val.fault = new SchedulingService.FaultTO();
            val.fault.message = "An error happened";
            
            bool expected = true; 
            bool actual;
            actual = Utils.HasFaultMessage(val);
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for HasFaultMessage
        ///</summary>
        [TestMethod()]
        public void HasFaultMessage__Sch_FalseTest()
        {
            MedRed.MDWSAccess.SchedulingService.AbstractTO val = new MedRed.MDWSAccess.SchedulingService.AddressTO();
            val.fault = null;

            bool expected = false;
            bool actual;
            actual = Utils.HasFaultMessage(val);
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for HasFaultMessage
        ///</summary>
        [TestMethod()]
        public void HasFaultMessage__Emr_TrueTest()
        {
            MedRed.MDWSAccess.EmrSvc.AbstractTO val = new MedRed.MDWSAccess.EmrSvc.AddressTO();
            val.fault = new EmrSvc.FaultTO();
            val.fault.message = "An error happened";

            bool expected = true;
            bool actual;
            actual = Utils.HasFaultMessage(val);
            Assert.AreEqual(expected, actual);
        }

        /// <summary>
        ///A test for HasFaultMessage
        ///</summary>
        [TestMethod()]
        public void HasFaultMessage__Emr_FalseTest()
        {
            MedRed.MDWSAccess.EmrSvc.AbstractTO val = new MedRed.MDWSAccess.EmrSvc.AddressTO();
            val.fault = null;

            bool expected = false;
            bool actual;
            actual = Utils.HasFaultMessage(val);
            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void ToMDWSAppointmentDateTime_Empty_Test()
        {
            DateTime? empty = null;
            var expected = "";

            var actual = Utils.ToMDWSAppointmentDateTime(empty);
            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void ToMDWSAppointmentDateTime_FullDate_Test()
        {
            DateTime? empty = new DateTime(2013, 10, 5, 13, 14, 15);
            var expected = "3131005.131415";

            var actual = Utils.ToMDWSAppointmentDateTime(empty);
            Assert.AreEqual(expected, actual);
        }

        [TestMethod()]
        public void ToMDWSAppointmentDateTime_HourDate_Test()
        {
            DateTime? empty = new DateTime(2013, 10, 5, 13, 0, 0);
            var expected = "3131005.13";

            var actual = Utils.ToMDWSAppointmentDateTime(empty);
            Assert.AreEqual(expected, actual);
        }


    }
}
