using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using MedRed.MDWSAccess;
using System.Collections.Generic;
using MedRed.MDWSAccess.EmrSvc;
using MedRed.MDWSAccess.SchedulingService;
using Shared.Model.Config.MDWS;
using Shared.Model;

namespace MedRed.MDWSAccess.Tests
{
    
    
    /// <summary>
    ///This is a test class for UtilsTest and is intended
    ///to contain all UtilsTest Unit Tests
    ///</summary>
    [TestClass()]
    public class CRUDTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {            
            var config = new MDWSConfiguration();
            config.BaseMDWS_Url = "http://1127.0.0.1/MDWS2/";
            config.DataSources.Add("555", new DataSource { SiteID = "555", Server = "127.0.0.1", Port = "9200" });

            config.DB_ConnectionString = "Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password";
            config.Caldav_Source = new Shared.Model.Config.Calendar.CalendarConfiguration()
            {
                BaseCalendarUri = new Uri("http://127.0.0.1:8080/ucaldav/user/mtwain/"),
                UserName = "mtwain",
                Password = "bedework"
            };


            var connection = new MDWSConnection() { SiteID = "555", AccessCode = "medred3", VerifyCode = "password" };

            MDWSCalls MDWSdao = new MDWSCalls();
            MDWSdao.setConfig(config);
            MDWSdao.setConnection(connection);

            TestContext.Properties["MDWSdao"] = MDWSdao;
        }
        
        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        [TestMethod()]
        public void GetHolidaysTest()
        {
            var MDWSdao = TestContext.Properties["MDWSdao"] as MDWSCalls;

            var holidays = MDWSdao.GetHolidays();
        }

        [TestMethod()]
        public void GetFacilitiesTest()
        {
            var MDWSdao = TestContext.Properties["MDWSdao"] as MDWSCalls;

            var holidays = MDWSdao.GetFacilities();
        }

        //[TestMethod()]
        //public void CreateProvider()
        //{
        //    var MDWSdao = TestContext.Properties["MDWSdao"] as MDWSCalls;

        //    Provider provider = new Provider()
        //    {
        //        Person = new Person()
        //        {
        //            FirstName = "John",
        //            LastName = "Doe",
        //            DateOfBirth = new DateTime(1980, 3, 3),
        //            Sex = "M",
        //            Email = "john@doe.com",
        //            SSN = "555-55-1212"
        //        },
        //        NPI = "123ABC45"
        //    };

        //    var result = MDWSdao.AddProvider(provider);
        //    Assert.IsFalse(String.IsNullOrEmpty(result));
        //}

        //[TestMethod()]
        //public void CreatePatient()
        //{
        //    var MDWSdao = TestContext.Properties["MDWSdao"] as MDWSCalls;

        //    var patient = new Patient()
        //    {
        //        ICN = "124",
        //        Person = new Person()
        //        {
        //            FirstName = "Henry",
        //            LastName = "Jackson",
        //            Sex = "M",
        //            DateOfBirth = new DateTime(1980, 1, 1),
        //            Email = "Jackson5@hotmail.com"
        //        }
        //    };

        //    var result = MDWSdao.AddPatient(patient);
        //    Assert.IsFalse(String.IsNullOrEmpty(result));

        //}

        [TestMethod()]
        public void CreateClinic()
        {
            var MDWSdao = TestContext.Properties["MDWSdao"] as MDWSCalls;

            Provider p = new Provider() { Id = 3, Person = new Person() { FirstName = "Henry", LastName = "Jones" } };
            p.AddProviderSite("555","11298");
            Site s = new Site() { Name = "S", VistaSiteId = "555" };
            Facility f = new Facility() { Name = "F", Site = s, ShortName="RIC" };
            Section sec = new Section() { Name = "Section", Facility = f, Abbreviation="SEC" };

            Resource resource = new Resource() { Name = "Dr. Jones", Type = ResourceType.Provider, FullfillingResourceId = 3, Section = sec};

            var result = MDWSdao.AddClinic(resource, p);
            Assert.IsFalse(String.IsNullOrEmpty(result));

        }

        [TestMethod()]
        public void GetAllProvidersTest()
        {
            var MDWSdao = TestContext.Properties["MDWSdao"] as MDWSCalls;

            var list = MDWSdao.GetAllProviders();
            
        }

        [TestMethod()]
        public void LoadSpecificProviderTest()
        {
            var MDWSdao = TestContext.Properties["MDWSdao"] as MDWSCalls;

            var list = MDWSdao.GetAllProviders();

            if (list.Count > 2)
            {
                string duz = list[2].GetDUZForVistASite("555");
                var provider = MDWSdao.LoadProvider(duz);
            }
        }
    }
}
