﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;
using Shared.Model.UserRoles;

namespace MedRed.DataAccess.Overrides
{
    public class UserMappingOverride : IAutoMappingOverride<User>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<User> mapping)
        {
            mapping.References<Person>(x => x.Person).Cascade.SaveUpdate();
            mapping.HasMany<UserRole>(x => x.Roles).Cascade.AllDeleteOrphan();
        }
    }
}
