﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class UIPageMappingOverride : IAutoMappingOverride<UIPage>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<UIPage> mapping)
        {
            mapping.Table("UiPageNavigation");
            mapping.References<UIPage>(x => x.ParentPage).Cascade.None();

            mapping.Map(x => x.PageHelp).Length(1000000);
        }
    }
}
