﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class SectionMappingOverride : IAutoMappingOverride<Section>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Section> mapping)
        {
            mapping.HasManyToMany<CommunicationTemplate>(x => x.CommunicationTemplates)
                .Table("Section_CommunicationTemplate_Rel").Cascade.AllDeleteOrphan();

            mapping.HasMany<AppointmentType>(x => x.AppointmentTypes).Not.KeyNullable(); //.Inverse().Cascade.AllDeleteOrphan();

            mapping.References<Facility>(x => x.Facility).Cascade.None();
            mapping.References<Service>(x => x.Service).Cascade.None();
        }
    }
}
