﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;
using Shared.Model.UserRoles;

namespace MedRed.DataAccess.Overrides
{
    public class RoleMappingOverride : IAutoMappingOverride<Role>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Role> mapping)
        {
            mapping.Map(x => x.Name).Column("RoleName");
            mapping.HasManyToMany<Shared.Model.UserRoles.Action>(x => x.Actions).Table("RoleAction").Cascade.None();
        }
    }
}
