﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class ResourceMappingOverride : IAutoMappingOverride<Resource>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Resource> mapping)
        {
            mapping.HasMany<Hold>(x => x.Holds);//.Inverse().Cascade.AllDeleteOrphan();
            mapping.HasMany<Block>(x => x.Blocks);//.Inverse().Cascade.AllDeleteOrphan();
            mapping.HasMany<SchedulingPolicy>(x => x.SchedulingPolicies); //.Inverse().Cascade.AllDeleteOrphan();

            mapping.References<Section>(x => x.Section).Cascade.None();
        }
    }
}
