﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class ProviderMappingOverride : IAutoMappingOverride<Provider>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Provider> mapping)
        {
//            mapping.LazyLoad();
            mapping.References<Person>(x => x.Person).Cascade.SaveUpdate();
//            mapping.HasMany<ProviderSite>(x => x.ProviderSites).Inverse().Cascade.AllDeleteOrphan();
            mapping.HasMany(x => x.ProviderSites)
                .AsMap<String>("VistaSiteId")
                .Table("Provider_Site_Rel")
                .KeyColumn("ProviderId")
                .Element("DUZ");
                
            //                .Where(

        }
    }
}
