﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class PatientMappingOverride : IAutoMappingOverride<Patient>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Patient> mapping)
        {
//            mapping.LazyLoad();
            mapping.References<Person>(x => x.Person).Cascade.SaveUpdate();
//            mapping.HasMany<PatientSite>(x => x.PatientSites).Inverse().Cascade.AllDeleteOrphan();
            mapping.HasMany(x => x.PatientSites)
                .AsMap<String>("VistaSiteId")
                .Table("Patient_Site_Rel")
                .KeyColumn("PatientId")
                .Element("DFN");


            mapping.HasMany<SpecialNeed>(x => x.SpecialNeeds).Not.KeyNullable(); //.Inverse().Cascade.AllDeleteOrphan();
            mapping.HasMany<PatientPreference>(x => x.Preferences).Not.KeyNullable();//.Inverse().Cascade.AllDeleteOrphan();

            mapping.Map(x => x.PreferencesOther).Length(1000000);
            mapping.Map(x => x.SpecialNeedsOther).Length(1000000);


            mapping.IgnoreProperty(x => x.HasInsurance);
            mapping.IgnoreProperty(x => x.ActiveInsurance);
            mapping.IgnoreProperty(x => x.EligibilityCode);
            mapping.IgnoreProperty(x => x.CurrentMeansStatus);
            mapping.IgnoreProperty(x => x.NeedsMeansTest);
            mapping.IgnoreProperty(x => x.MilitaryStatus);
            mapping.IgnoreProperty(x => x.Occupation);
            mapping.IgnoreProperty(x => x.IsVeteran);
            mapping.IgnoreProperty(x => x.ServiceConnected);
            mapping.IgnoreProperty(x => x.SCPercent);
            mapping.IgnoreProperty(x => x.Religion);
            mapping.IgnoreProperty(x => x.PatientType);
        }
    }
}
