﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class FacilityMappingOverride : IAutoMappingOverride<Facility>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Facility> mapping)
        {
            mapping.HasManyToMany<CommunicationTemplate>(x => x.CommunicationTemplates)
                .Table("Facility_CommunicationTemplate_Rel").Cascade.AllDeleteOrphan();

            mapping.References<Site>(x => x.Site).Cascade.None();

//            mapping.IgnoreProperty(x => x.iCommunicationTemplates);

//            mapping.HasOne<Address>(x => x.Address).Cascade.All();
        }
    }
}
