﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class CommunicationQueueMappingOverride : IAutoMappingOverride<CommunicationQueueItem>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<CommunicationQueueItem> mapping)
        {
            mapping.References<Appointment>(x => x.Appointment).Cascade.None();
            mapping.References<AppointmentRequest>(x => x.AppointmentRequest).Cascade.None();
            mapping.References<CommunicationTemplate>(x => x.Template).Cascade.None();

            mapping.Map(x => x.Body).Length(1000000);

        }
    }
}
