﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class AppointmentRequestMappingOverride : IAutoMappingOverride<AppointmentRequest>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<AppointmentRequest> mapping)
        {
            mapping.References<User>(x => x.CreatingUser).Cascade.None();
            mapping.References<Patient>(x => x.Patient).Cascade.None();
            mapping.References<Section>(x => x.RequestedSection).Cascade.None();
            mapping.References<Resource>(x => x.RequestedResource).Cascade.None();
            mapping.References<Appointment>(x => x.CausingAppointment).Cascade.None();
            mapping.References<Appointment>(x => x.ResultingAppointment).Cascade.None();

            mapping.Map(x => x.Notes).Length(1000000);
        }
    }
}
