﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;

namespace MedRed.DataAccess.Overrides
{
    public class AppointmentMappingOverride : IAutoMappingOverride<Appointment>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Appointment> mapping)
        {
            mapping.HasManyToMany<Resource>(x => x.Resources).Table("Appointment_Resource_Rel").Cascade.None();

            mapping.HasMany<AppointmentActivity>(x => x.Activity); //.Inverse().Cascade.AllDeleteOrphan();

            mapping.HasMany<AppointmentRelation>(x => x.ChildAppointments); //.Inverse().Cascade.AllDeleteOrphan();

            mapping.References<Patient>(x => x.Patient).Cascade.None();
            mapping.References<Section>(x => x.Section).Cascade.None();

            mapping.References<AppointmentType>(x => x.AppointmentType).Cascade.None();
        }
    }
}
