﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FluentNHibernate.Automapping.Alterations;
using Shared.Model;
using Shared.Model.UserRoles;

namespace MedRed.DataAccess.Overrides
{
    public class ActionMappingOverride : IAutoMappingOverride<Shared.Model.UserRoles.Action>
    {
        public void Override(FluentNHibernate.Automapping.AutoMapping<Shared.Model.UserRoles.Action> mapping)
        {
            mapping.Map(x => x.Name).Column("ActionName");
            mapping.Map(x => x.Description).Column("ActionDesc").Not.Nullable();
            mapping.Map(x => x.Key).Column("ActionKey").Not.Nullable();
        }
    }
}
