﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using FluentNHibernate;
using FluentNHibernate.Automapping;
using FluentNHibernate.Cfg;
using FluentNHibernate.Cfg.Db;
using FluentNHibernate.Conventions;
using FluentNHibernate.Conventions.Helpers;
using MedRed.DataAccess.Overrides;
using NHibernate;
using NHibernate.Cfg;
using Shared.Model;

namespace MedRed.DataAccess
{
    public class DataAccess
    {
        static ISessionFactory _sessionFactory = null;
        static string _connectionString = String.Empty;

        private static FluentConfiguration GetConfiguration()
        {
            var config = Fluently.Configure()
                .Database(MsSqlConfiguration.MsSql2008
                    .ConnectionString(_connectionString))
                .Mappings(m => m.AutoMappings.Add(CreateAutomappings));
//                .ExposeConfiguration(c => c.SetProperty("show_sql", "true"));

            return config;
        }

        private static ISessionFactory CreateSessionFactory()
        {
            var config = GetConfiguration();

            return config.BuildSessionFactory();
        }

        private static AutoPersistenceModel CreateAutomappings()
        {
            return AutoMap
                .AssemblyOf<Site>()
                .Where(t => ( //t.Namespace == "Shared.Model" && 
                    !t.GetInterfaces().Contains(typeof(ExcludeMapping))
                    ))
                    .Conventions.Add
                     (
                        ForeignKey.EndsWith("Id"),
                        DefaultLazy.Never(), 
                        DefaultCascade.All()
                     )
                .UseOverridesFromAssemblyOf<FacilityMappingOverride>()
            ;
        }

        public static void SetConnectionString(string connectionString)
        {
            _connectionString = connectionString;
            if (_sessionFactory != null)
            {
                _sessionFactory.Close();
                _sessionFactory = null;
            }
        }

        public static void ValidateSchema()
        {
            var config = GetConfiguration(); 
            var nHconfig = config.BuildConfiguration();

            var validator = new NHibernate.Tool.hbm2ddl.SchemaValidator(nHconfig);
            validator.Validate();
        }

        public static ISession OpenSession()
        {
            if (_sessionFactory == null)
            {
                _sessionFactory = CreateSessionFactory();
            }

            return _sessionFactory.OpenSession();
        }

        public static void CloseSession(ISession session)
        {
            if (session != null)
            {
                if (session.IsOpen)
                {
                    session.Flush();
                    session.Close();
                }                
                session.Dispose();
            }
        }

        public static void CloseSessionFactory()
        {
            if (_sessionFactory == null)
            {
                _sessionFactory.Close();
                _sessionFactory = null;
            }
        }
    }
}
