using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using NHibernate;
using System.Linq;
using NHibernate.Linq;
using Shared.Model;
using KellermanSoftware.CompareNetObjects;

namespace MedRed.DataAccess.Tests
{
    [TestClass]
    public class FacilityTests
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {
            DataAccess.SetConnectionString("Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password");
        }

        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        [TestMethod()]
        public void CreateFacilityTest()
        {
            using (var session = DataAccess.OpenSession())
            {
                Site newSite = new Site()
                {
                    VistaSiteId = "102",
                    Name = "FacilityTest",
                    Phone = "555-555-1213",
                    Address = new Address() { Street1 = "Another Street line 1", Street2 = "Another Street line 2" }
                };

                Facility newFacility = new Facility()
                {
                    Site = newSite,
                    Name = "The Hospital",
                    Address = new Address() { Street1 = "123 Main Street", Street2 = "Anytown, USA" },
                    Phone = "555-555-1234"
                };


                Assert.IsTrue(newFacility.Id == 0);
                using (ITransaction transaction = session.BeginTransaction())
                {
                    session.Save(newSite);
                    session.Save(newFacility);
                    transaction.Commit();
                }
                Assert.IsTrue(newFacility.Id != 0);

                int Id = newFacility.Id;

                session.Clear();

                var facilityResult = from f in session.Query<Facility>()
                                     where f.Id == Id
                                     select f;
                var facility = facilityResult.First();

                CompareObjects compareObjects = new CompareObjects();

                Assert.IsTrue(compareObjects.Compare(facility, newFacility), compareObjects.DifferencesString);
            }
            //session.Delete(newSite);
        }

        [TestMethod()]
        public void AddCommunicationTemplateToFacilityTest()
        {
            using (var session = DataAccess.OpenSession())
            {
                Site newSite = new Site()
                {
                    VistaSiteId = "102",
                    Name = "FacilityTest",
                    Phone = "555-555-1213",
                    Address = new Address() { Street1 = "Another Street line 1", Street2 = "Another Street line 2" }
                };

                Facility newFacility = new Facility()
                {
                    Site = newSite,
                    Name = "The Hospital",
                    Address = new Address() { Street1 = "123 Main Street", Street2 = "Anytown, USA" },
                    Phone = "555-555-1234"
                };

                CommunicationTemplate commTemplate = new CommunicationTemplate()
                {
                    Name = "Standard Pre Appt Template",
                    Type = CommunicationType.PreAppointment,
                    Message = "Dear <Patient name>  Please fast for 24 hours before your appointment with <doctor> and <appt.time>"
                };

                newFacility.CommunicationTemplates.Add(commTemplate);

                Assert.IsTrue(newFacility.Id == 0);
                Assert.AreEqual(newFacility.CommunicationTemplates.Count, 1);

                using (ITransaction transaction = session.BeginTransaction())
                {
                    session.Save(newSite);
                    session.Save(newFacility);
                    transaction.Commit();
                }
                Assert.IsTrue(newFacility.Id != 0);

                int Id = newFacility.Id;

                session.Clear();

                var facilityResults = from f in session.Query<Facility>()
                                      where f.Id == Id
                                      select f;
                var facility = facilityResults.First();

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(facility, newFacility), compareObjects.DifferencesString);
            }
            //session.Delete(newSite);
        }

    }
}
