using MedRed.DataAccess;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using NHibernate;
using System.Linq;
using NHibernate.Linq;
using FluentNHibernate.Automapping;
using Shared.Model;
using System.Collections.Generic;
using System.Reflection;
using KellermanSoftware.CompareNetObjects;

namespace MedRed.DataAccess.Tests
{
    
    
    /// <summary>
    ///This is a test class for DataAccessTest and is intended
    ///to contain all DataAccessTest Unit Tests
    ///</summary>
    [TestClass()]
    public class DataAccessTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        // 
        //You can use the following additional attributes as you write your tests:
        //
        //Use ClassInitialize to run code before running the first test in the class
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Use ClassCleanup to run code after all tests in a class have run
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Use TestInitialize to run code before running each test
        [TestInitialize()]
        public void MyTestInitialize()
        {
            DataAccess.SetConnectionString("Data Source=127.0.0.1;Initial Catalog=SchedulingTestDB;Persist Security Info=True;User ID=sa;Password=password");
        }

        //Use TestCleanup to run code after each test has run
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///A test for CloseSession
        ///</summary>
        [TestMethod()]
        public void CloseSessionTest()
        {
            DataAccess target = new DataAccess();
            ISession session = DataAccess.OpenSession();
            DataAccess.CloseSession(session);
        }


        /// <summary>
        ///A test for OpenSession
        ///</summary>
        [TestMethod()]
        public void OpenSessionTest()
        {
            DataAccess target = new DataAccess();

//            ISession expected = null;
            ISession actual;
            actual = DataAccess.OpenSession();
            //Assert.AreEqual(expected, actual);
            //Assert.Inconclusive("Verify the correctness of this test method.");
        }

        /// <summary>
        ///A test for OpenSession
        ///</summary>
        [TestMethod()]
        public void CreateSiteTest()
        {
            using (var session = DataAccess.OpenSession())
            {
                Site newSite = new Site()
                {
                    VistaSiteId = "101",
                    Name = "VistA EHR",
                    Phone = "555-555-1213",
                    Address = new Address() { Street1 = "Another Street line 1", Street2 = "Another Street line 2" }
                };

                Assert.IsTrue(newSite.Id == 0);
                using (ITransaction transaction = session.BeginTransaction())
                {
                    //                session.Save(newSite.Address);
                    session.Save(newSite);
                    transaction.Commit();
                }
                Assert.IsTrue(newSite.Id != 0);

                int Id = newSite.Id;

                var siteResult = from s in session.Query<Site>()
                                 where s.Id == Id
                                 select s;
                var site = siteResult.First();

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(site, newSite), compareObjects.DifferencesString);
            }
            //session.Delete(newSite);
        }

        /// <summary>
        ///A test for OpenSession
        ///</summary>
        [TestMethod()]
        public void DeleteSiteTest()
        {
            using (var session = DataAccess.OpenSession())
            {
                Site newSite = new Site() { VistaSiteId = "100", Name = "VistA EHR", Phone = "555-555-1212" };

                Assert.IsTrue(newSite.Id == 0);
                session.Save(newSite);
                Assert.IsTrue(newSite.Id != 0);

                int Id = newSite.Id;

                var siteResults = from s in session.Query<Site>()
                                  where s.Id == Id
                                  select s;
                var site = siteResults.First();

                CompareObjects compareObjects = new CompareObjects();
                Assert.IsTrue(compareObjects.Compare(site, newSite), compareObjects.DifferencesString);

                session.Delete(newSite);
                session.Flush();

                siteResults = from s in session.Query<Site>()
                              where s.Id == Id
                              select s;

                Assert.IsTrue(siteResults.Count() == 0);
            }
        }

        /// <summary>
        ///A test for OpenSession
        ///</summary>
        [TestMethod()]
        public void ValidateSchemaTest()
        {
            DataAccess.ValidateSchema();            
        }

    }
}
