﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using net.kvdb.webdav;

namespace MedRed.CalendarAccess
{
    internal class WebDAVUtils
    {
        private AutoResetEvent autoResetEvent;
        private WebDAVClient client;
        int result;

        public WebDAVUtils(WebDAVClient _client)
        {
            client = _client;
            autoResetEvent = new AutoResetEvent(false);
        }

        public bool CreateDirectory(string path)
        {
            autoResetEvent.Reset();
            client.CreateDirComplete += client_actionComplete;
            client.CreateDir(path);
            autoResetEvent.WaitOne();
            client.CreateDirComplete -= client_actionComplete;
            if (result == 0)
                return true;
            return false;
        }

        public bool DeletePath(string path)
        {
            autoResetEvent.Reset();
            client.DeleteComplete += client_actionComplete;
            client.Delete(path);
            autoResetEvent.WaitOne();
            client.DeleteComplete -= client_actionComplete;
            if (result == 201)
                return true;
            return false;
        }

        void client_actionComplete(int statusCode)
        {
            result = statusCode;
            autoResetEvent.Set();
        }
    }
}
