﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading;
using Independentsoft.Webdav;

namespace MedRed.CalendarAccess
{
    internal class WebDAV
    {
        NetworkCredential credentials;
        Uri baseUri;

        public WebDAV(Uri baseUri, string username, string pass)
        {
            credentials = new NetworkCredential(username, pass);
            this.baseUri = baseUri;
        }

        public bool CreateDirectory(string path)
        {
            WebdavSession session = new WebdavSession(credentials);
            Resource resource = new Resource(session);

            Uri fullPath = new Uri(baseUri, path);
            bool result = resource.CreateFolder(fullPath.AbsoluteUri);
            
            return result;
        }

        public bool DeletePath(string path)
        {
            WebdavSession session = new WebdavSession(credentials);
            Resource resource = new Resource(session);

            Uri fullPath = new Uri(baseUri, path);
            bool result = resource.Delete(fullPath.AbsoluteUri);

            return result;
        }
    }
}
