﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using CalDav;
using Shared.Model;

namespace MedRed.CalendarAccess
{
    public interface ICalendarAccess
    {
        bool IsCaldavEnabled();

        CalDav.Client.Calendar GetCalendar(Resource resource);
        CalDav.Client.Calendar GetCalendar(Patient patient);

        bool IsCalendarPresent(Resource resource);
        bool IsCalendarPresent(Patient patient);

        bool DeleteCalendar(Resource resource);
        bool DeleteCalendar(Patient patient);

        Event[] FindAppointments(Resource resource, DateTime start, DateTime end);
        Event[] FindAppointments(Patient patient, DateTime start, DateTime end);

        Event GetAppointment(Appointment appointment);

        bool SaveAppointment(Resource resource, Event appointment);

        bool SaveAppointment(Appointment appointment);
        bool UpdateAppointment(Appointment appointment);
        bool DeleteAppointment(Appointment appointment);
    }
}
