﻿CREATE TABLE [dbo].[UIMenu]
(
	[Id] INT NOT NULL PRIMARY KEY, 
    [MenuText] NVARCHAR(32) NOT NULL, 
    [ResourceAddress] NVARCHAR(1000) NULL, 
    [ParentId] INT NULL, 
    [SeparatorAfter] BIT NOT NULL, 
    [CommandArgument] NVARCHAR(50) NULL
)

GO

EXEC sp_addextendedproperty @name = N'MS_Description',
    @value = N'Add keys manually as we want to control the menu structure. Items Rendered in UI in key order',
    @level0type = N'SCHEMA',
    @level0name = N'dbo',
    @level1type = N'TABLE',
    @level1name = N'UIMenu',
    @level2type = N'COLUMN',
    @level2name = N'Id'
GO
EXEC sp_addextendedproperty @name = N'MS_Description',
    @value = N'When no resource address - a postback command argument',
    @level0type = N'SCHEMA',
    @level0name = N'dbo',
    @level1type = N'TABLE',
    @level1name = N'UIMenu',
    @level2type = N'COLUMN',
    @level2name = N'CommandArgument'
GO
EXEC sp_addextendedproperty @name = N'MS_Description',
    @value = N'Address of resource to load (page, file, etc) - if null, postback with command argument',
    @level0type = N'SCHEMA',
    @level0name = N'dbo',
    @level1type = N'TABLE',
    @level1name = N'UIMenu',
    @level2type = N'COLUMN',
    @level2name = N'ResourceAddress'