﻿CREATE TABLE [dbo].[CommunicationQueueItem]
(
	[Id] INT NOT NULL PRIMARY KEY IDENTITY, 
    [Recipient] NVARCHAR(50) NULL, 
    [Medium] NVARCHAR(50) NULL, 
    [SendBy] DATETIME NULL, 
    [SentOn] DATETIME NULL, 
    [Subject] NVARCHAR(400) NULL, 
    [Body] NVARCHAR(MAX) NULL, 
    [AppointmentId] INT NULL, 
    [AppointmentRequestId] INT NULL, 
    [TemplateId] INT NULL, 
    CONSTRAINT [FK_CommunicationQueueItem_Appointment] FOREIGN KEY ([AppointmentId]) REFERENCES [Appointment]([Id]), 
    CONSTRAINT [FK_CommunicationQueueItem_AppointmentRequest] FOREIGN KEY ([AppointmentRequestId]) REFERENCES [AppointmentRequest]([Id]), 
    CONSTRAINT [FK_CommunicationQueue_CommunicationTemplate] FOREIGN KEY ([TemplateId]) REFERENCES [CommunicationTemplate]([Id])
)
