﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services;

namespace BT.Health.SchedulingWeb.User_Controls
{
    public partial class ctl_CurrentResource : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            UserSession userSession = Helper.GetUserSession(Page);

            if (userSession.Facil != null)
            {
                if (userSession.Facil.Id != 0)
                {
                    lblFacility.Text = userSession.Facil.Name;
                }
            }
            
            if (userSession.Clinic != null)
            {
                if (userSession.Clinic.Id != 0)
                {
                    lblFacility.Text += "/" + userSession.Clinic.Name;
                }
            }

            if (userSession.CurrentResource != null)
            {
                lblResourceHeader.Visible = true;
                lblCurrentResource.Visible = true;

                if (userSession.CurrentResource.Id != 0)
                {
                    lblCurrentResource.Text = userSession.CurrentResource.Name;
                }
                else
                {
                    lblCurrentResource.Text = "na";
                }
            }
            else
            {
                lblResourceHeader.Visible = false;
                lblCurrentResource.Visible = false;
            }
           
        }
    }
}