﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using Shared.Model;
using MedRed.Services;
using Shared.Model.Config.MDWS;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.User_Controls
{
    public partial class WucVistaSiteSelector : System.Web.UI.UserControl
    {
        /// <summary>
        /// Raised when the user selects a vista site
        /// Command returned is "VistaSiteSelected" or "Cancelled"
        /// </summary>
        public event EventHandler<CommandEventArgs> VistaSiteSelected;

        /// <summary>
        /// Raise the VistaSiteSelected event
        /// </summary>
        /// <param name="commandName"></param>
        /// <param name="commandArgument"></param>
        protected void OnVistaSiteSelected(string commandName, string commandArgument)
        {
            // get our own copy as per Microsoft standards
            EventHandler<CommandEventArgs> ceh = VistaSiteSelected;
            if (ceh != null)
                ceh(this, new CommandEventArgs(commandName, commandArgument));
        }
        
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        public void ShowVistaSites(string selectedSiteId)
        {
            // load sites
            Factory f = Helper.GetFactory(Page);
            
            var service = f.GetSiteService();
            lv.DataSource = (from s in service.Get()
                             orderby s.Name
                             select s).ToList();
            lv.DataBind();

            // highlight selected now that we are bound
            foreach(var itm in lv.Items)
            {
                LinkButton lbSelectVistaSite = itm.RecursiveFindControl("lbSelectVistaSite") as LinkButton;

                if (lbSelectVistaSite != null)
                {
                    lbSelectVistaSite.ToolTip = "Select Site";

                    if (lbSelectVistaSite.CommandArgument.ToString() == selectedSiteId)
                    {
                        lbSelectVistaSite.CssClass = "listItemSelected";
                        lbSelectVistaSite.ToolTip = "Currently Selected";
                    }
                }
            }
        }

        protected void lv_ItemCommand(object sender, ListViewCommandEventArgs e)
        {
            if (e.CommandName == "SelectVistaSite")
            {
                OnVistaSiteSelected("SelectVistaSite", e.CommandArgument.ToString());
            }
        }

        protected void lbCloseWindow_Click(object sender, EventArgs e)
        {
            OnVistaSiteSelected("Cancel", string.Empty);
        }
    }
}