﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb.User_Controls
{
    public partial class WucResourceList : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// Display "no resources"
        /// </summary>
        /// <param name="resources"></param>
        public void ShowEmptyResources()
        {
            lv.DataSource = null;
            lv.DataBind();
        }

        /// <summary>
        /// Show a list of resources
        /// </summary>
        /// <param name="resources"></param>
        public void ShowResources(List<Resource> resources)
        {
            int siteId = UISession.Helper.GetUserSession(Page).CurrentSite.Id;
            Factory factory = Helper.GetFactory(Page);

            List<BasicResourceData> resourcesList = new List<BasicResourceData>();

            //-------------------------------------------------------------------------
            // Add providers to list
            var providerService = factory.GetProviderService();
            var siteProviders = providerService.GetAllForSite(siteId);

            var proivderResources = (from r in resources
                                     where r.Type == ResourceType.Provider
                                     select r).ToList();

            // get provider names from resource to provide link
            resourcesList.AddRange((from p in siteProviders
                                    join r in proivderResources
                                    on p.Id equals r.FullfillingResourceId
                                    select new BasicResourceData
                                    {
                                        ResourceId = r.Id,
                                        ResourceType = Shared.Model.ResourceType.Provider,
                                        ResourceName = p.Person.GetFullName()
                                    }).ToList());

            //-------------------------------------------------------------------------
            // Add rooms to list
            var roomService = factory.GetRoomService();
            var rooms = roomService.GetAllForSite(siteId);

            var roomResources = (from r in resources
                                 where r.Type == ResourceType.Room
                                 select r).ToList();

            // get provider names from resource to provide link
            resourcesList.AddRange((from x in rooms
                                    join r in roomResources
                                    on x.Id equals r.FullfillingResourceId
                                    select new BasicResourceData
                                    {
                                        ResourceId = r.Id,
                                        ResourceType = Shared.Model.ResourceType.Room,
                                        ResourceName = x.Name + " (floor " + x.Floor + ")"
                                    }).ToList());

            //-------------------------------------------------------------------------
            // Add equipment to list
            var equipmentService = factory.GetEquipmentService();
            var equipment = equipmentService.GetAllForSite(siteId);

            var equipmentResources = (from r in resources
                                      where r.Type == ResourceType.Equipment
                                      select r).ToList();

            // get provider names from resource to provide link
            resourcesList.AddRange((from e in equipment
                                    join r in equipmentResources
                                    on e.Id equals r.FullfillingResourceId
                                    select new BasicResourceData
                                    {
                                        ResourceId = r.Id,
                                        ResourceType = Shared.Model.ResourceType.Equipment,
                                        ResourceName = e.Name
                                    }).ToList());

            //-------------------------------------------------------------------------
            // Show in display
            lv.DataSource = resourcesList;
            lv.DataBind();
        }
    }
}