﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="WucPatientSearch.ascx.cs" Inherits="BT.Health.SchedulingWeb.User_Controls.WucPatientSearch" %>
<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<style type="text/css">
    .auto-style1 {
        height: 16px;
    }
</style>
<asp:UpdatePanel ID="UpdatePanel1" runat="server">
    <ContentTemplate>
        <div>
            <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
        </div>
        <asp:MultiView ID="mvPatients" runat="server" ActiveViewIndex="0">
            <asp:View ID="viewPatients" runat="server">
                <asp:Panel ID="Panel1" runat="server" DefaultButton="lbSearch" Style="margin-bottom: 20px; border-bottom: 1px solid silver;">
                    <asp:TextBox ID="tbSearch" runat="server" MaxLength="16"></asp:TextBox>&nbsp;<asp:LinkButton ID="lbSearch" runat="server" CssClass="linkAsButton" OnClick="lbSearch_Click">Search</asp:LinkButton>
                    <div style="margin: 2px 0;">Enter starting letters of a surname, a full SSN, or leave blank (then, press enter or click search)</div>
                    <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
                </asp:Panel>
                <asp:ListView ID="lvPatients" runat="server" OnItemDataBound="lvPatients_ItemDataBound" OnItemCommand="lvPatients_ItemCommand">
                    <EmptyDataTemplate>
                        No Patients were found matching this search
                    </EmptyDataTemplate>
                    <ItemTemplate>
                        <tr class="gridViewRowStyle">
                            <td>
                                <asp:LinkButton ID="lbPatient" runat="server" CommandName="VewPatientDetails" ToolTip="View more patient details"></asp:LinkButton>
                            </td>
                            <td runat="server" id="tdDateOfBirth"></td>
                            <td runat="server" id="tdSex"></td>
                            <td runat="server" id="tdSSN"></td>
                        </tr>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                        <tr class="gridViewAlternatingRowStyle">
                            <td>
                                <asp:LinkButton ID="lbPatient" runat="server" CommandName="VewPatientDetails" ToolTip="View more patient details"></asp:LinkButton>
                            </td>
                            <td runat="server" id="tdDateOfBirth"></td>
                            <td runat="server" id="tdSex"></td>
                            <td runat="server" id="tdSSN"></td>
                        </tr>
                    </AlternatingItemTemplate>
                    <LayoutTemplate>
                        <div style="width: 500px; margin: 0 auto;">
                            <div style="margin-bottom: 10px;">Click a name to verify the patient's details</div>
                            <div style="height: 500px; overflow: auto;">
                                <table class="gridView" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>D.O.B.</th>
                                            <th>Sex</th>
                                            <th>SSN</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr runat="server" id="itemPlaceholder"></tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </LayoutTemplate>
                </asp:ListView>
            </asp:View>
            <asp:View ID="viewPatient" runat="server">
                <div style="margin-bottom: 10px;">
                    <asp:LinkButton ID="lbBackToPatients" runat="server" ToolTip="Go back to the patients list" OnClick="lbBackToPatients_Click">Go back to the Patient list</asp:LinkButton>
                </div>
                <div style="width: 500px; margin: 0 auto;">
                    <table class="tblDataEntry" style="width: 100%;">
                        <tr>
                            <td>Name</td>
                            <td runat="server" id="tdName"></td>
                        </tr>
                        <tr>
                            <td>Address</td>
                            <td runat="server" id="tdAddress"></td>
                        </tr>
                        <tr>
                            <td>Phone</td>
                            <td runat="server" id="tdPhone"></td>
                        </tr>
                        <tr>
                            <td>Date of Birth</td>
                            <td runat="server" id="tdDateOfBirth"></td>
                        </tr>
                        <tr>
                            <td>SSN</td>
                            <td runat="server" id="tdSSN"></td>
                        </tr>
                        <tr>
                            <td>Sex</td>
                            <td runat="server" id="tdSex"></td>
                        </tr>
                        <tr>
                            <td>Marital Status</td>
                            <td runat="server" id="tdMaritalStatus"></td>
                        </tr>
                        <tr>
                            <td>Ethnicity</td>
                            <td runat="server" id="tdEthnicity"></td>
                        </tr>
                        <tr>
                            <td>Email</td>
                            <td runat="server" id="tdEMail"></td>
                        </tr>
                         <tr>
                            <td>Has Insurance</td>
                            <td runat="server" id="tdInsurance"></td>
                        </tr>
                         <tr>
                            <td>Active Insurance</td>
                            <td runat="server" id="tdActiveInsurance"></td>
                        </tr>
                         <tr>
                            <td>Eligibility Code</td>
                            <td runat="server" id="tdEligibilityCode"></td>
                        </tr>
                         <tr>
                            <td>Current Means Status</td>
                            <td runat="server" id="tdCurrentMeansStatus"></td>
                        </tr>
                          <tr>
                            <td>Needs Means Test</td>
                            <td runat="server" id="tdNeedsMeansTest"></td>
                        </tr>
                          <tr>
                            <td>Military Status</td>
                            <td runat="server" id="tdMilitaryStatus"></td>
                        </tr>
                          <tr>
                            <td>Current Means Status</td>
                            <td runat="server" id="td3"></td>
                        </tr>
                          <tr>
                            <td>Occupation</td>
                            <td runat="server" id="tdOccupation"></td>
                        </tr>
                          <tr>
                            <td>Is Veteran</td>
                            <td runat="server" id="tdIsVeteran"></td>
                        </tr>
                         <tr>
                            <td>SC Percent</td>
                            <td runat="server" id="tdSCPercent"></td>
                        </tr>
                         <tr>
                            <td>Service Connected</td>
                            <td runat="server" id="tdServiceConnected"></td>
                        </tr>
                         <tr>
                            <td class="auto-style1">Religion</td>
                            <td runat="server" id="tdReligion" class="auto-style1"></td>
                        </tr>
                          <tr>
                            <td class="auto-style1">PatientType</td>
                            <td runat="server" id="tdPatientType" class="auto-style1"></td>
                        </tr>
                        <tr>
                            <td class="auto-style1">Patient Preferences</td>
                            <td runat="server" id="tdPreferences" class="auto-style1"></td>
                        </tr>
                        <tr>
                            <td class="auto-style1">Patient Preferences (Other)</td>
                            <td runat="server" id="tdPreferencesOther" class="auto-style1"></td>
                        </tr>
                        <tr>
                            <td class="auto-style1">Special Needs</td>
                            <td runat="server" id="tdSpecialNeeds" class="auto-style1"></td>
                        </tr>
                        <tr>
                            <td class="auto-style1">Special Needs (Other)</td>
                            <td runat="server" id="tdSpecialNeedsOther" class="auto-style1"></td>
                        </tr>
                        <tr>
                            <td class="auto-style1">Primary Care Provider</td>
                            <td runat="server" id="tdPrimaryCareProvider" class="auto-style1"></td>
                        </tr>
                         
                        <tr>
                            <td></td>
                            <td>
                                <asp:LinkButton ID="lbNavigateForwards" runat="server" CssClass="linkAsButton" OnClick="lbNavigateForwards_Click">Select Patient</asp:LinkButton>
                            </td>
                        </tr>
                    </table>
                </div>
            </asp:View>
        </asp:MultiView>
    </ContentTemplate>
</asp:UpdatePanel>

