﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services.Interfaces;

namespace BT.Health.SchedulingWeb.User_Controls
{
    public partial class WucDateTimePicker : System.Web.UI.UserControl
    {
        bool _showTimeZoneName = false;

        /// <summary>
        /// true to show the time zone name
        /// </summary>
        public bool ShowTimeZoneName
        {
            get { return _showTimeZoneName; }
            set { _showTimeZoneName = value; }
        }

        /*
        /// <summary>
        /// Raised when a date/time is selected on the client
        /// </summary>
        public event EventHandler<DateTimeEventArgs> DateTimeSelected;

        protected void OnDateTimeSelected(DateTimeEventArgs dtea)
        {
            EventHandler<DateTimeEventArgs> eh = DateTimeSelected;

            if (eh != null)
            {
                eh(this, dtea);
            }
        }
         * */

        /// <summary>
        /// instantiate a local time zone
        /// </summary>
        TimeZoneInfo _timeZone = null;

        protected override void OnInit(EventArgs e)
        {
            base.OnInit(e);
            Page.RegisterRequiresControlState(this);

            if (!IsPostBack)
            {
                InitControl();
            }
        }

        protected override object SaveControlState()
        {
            Dictionary<string, object> dic = new Dictionary<string, object>();
            dic.Add("_timeZone", _timeZone);
            dic.Add("base", base.SaveControlState());

            return dic;
        }

        protected override void LoadControlState(object savedState)
        {
            Dictionary<string, object> dic = savedState as Dictionary<string, object>;

            if (dic != null)
            {
                if (dic["_timeZone"] != null && dic["_timeZone"] is TimeZoneInfo)
                    _timeZone = dic["_timeZone"] as TimeZoneInfo;

                base.LoadControlState(dic["base"]);
            }
            else
            {
                base.LoadControlState(savedState);
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {

        }

        void InitControl()
        {
            try
            {
                // initialise with a valid date/time - any timezone will do
                tbDateTime.Text = DateTime.UtcNow.ToMediumFormat();

                // assume no time zone set
                lblTimeZoneName.Text = "UTC [No Time Zone set]";
                lblTimeZoneName.Attributes.CssStyle.Add(HtmlTextWriterStyle.Color, "red");

                // See if user has set a time zone - if not, set from the current site (if there is one)
                if (_timeZone == null)
                {
                    var userSession = Helper.GetUserSession(Page);

                    if (userSession != null)
                    {
                        // show time zone
                        if (userSession.CurrentSite != null)
                        {
                            _timeZone = TimeZoneInfo.FindSystemTimeZoneById(userSession.CurrentSite.TimeZoneId);
                            lblTimeZoneName.Text = _timeZone.DisplayName;
                            lblTimeZoneName.Attributes.CssStyle.Remove(HtmlTextWriterStyle.Color);
                            tbDateTime.Text = TimeZoneInfo.ConvertTimeFromUtc(DateTime.UtcNow, _timeZone).ToMediumFormat();
                        }
                    }
                }
            }
            catch (System.Exception ex)
            {
                Response.Write("<script>alert('" + ex.Message + " - This has been logged');</script>");
                ex.Log();
            }
        }


        protected void Page_PreRender(object sender, EventArgs e)
        {
            divTimeZoneName.Visible = _showTimeZoneName;

            // this will only run when the control is rendered to the client
            LoadJavascript();
        }


        /// <summary>
        /// Gets or sets the seletced date for the Time zone of the currently selected VISTA site
        /// </summary>
        public DateTime? SelectedDateUTC
        {
            get
            {
                DateTime dt = DateTime.MinValue;

                if (DateTime.TryParse(tbDateTime.Text, out dt))
                {
                    DateTime t = Convert.ToDateTime(dt.Date);
                    dt = t;
                    // return local time in UTC
                    return TimeZoneInfo.ConvertTimeFromUtc(dt, _timeZone);
                }
                else
                {
                    return null;
                }
            }


        }
        /// <summary>
        /// Gets or sets the seletced date/time for the Time zone of the currently selected VISTA site
        /// </summary>
        public DateTime? SelectedDateTimeUTC
        {
            get
            {
                DateTime dt = DateTime.MinValue;

                if (DateTime.TryParse(tbDateTime.Text, out dt))
                {
                    // return local time in UTC
                    return TimeZoneInfo.ConvertTimeToUtc(dt, _timeZone);
                }
                else
                {
                    return null;
                }
            }

            set
            {
                if (value.HasValue)
                {
                    if (_timeZone != null)
                    {
                        // show UTC in local time
                        tbDateTime.Text = value.Value.ToMediumFormatFromUtc(_timeZone);
                    }
                    else
                    {
                        tbDateTime.Text = value.Value.ToMediumFormat();
                    }
                }
                else
                {
                    // no value, so any time regardless of timezone will do
                    tbDateTime.Text = DateTime.UtcNow.ToMediumFormat();
                }
            }
        }

        /// <summary>
        /// Gets the displayed date and time
        /// This will be in the time zone of the "ShowTimeZoneName" property
        /// To convert to UTC you need to call something like [TimeZoneInfo.ConvertTimeFromUtc(myDateTime, myTimeZoneInfo);]
        /// </summary>
        public DateTime? DisplayedDateTime
        {
            get
            {
                DateTime dt = DateTime.MinValue;

                if (DateTime.TryParse(tbDateTime.Text, out dt))
                {
                    // return displayed date time - this is in thw working time zone
                    return dt;
                }
                else
                {
                    return null;
                }
            }
        }

        protected void tbDateTime_TextChanged(object sender, EventArgs e)
        {
            //OnDateTimeSelected(new DateTimeEventArgs() { UtcDateTime = this.SelectedDateTimeUTC });
        }

        /// <summary>
        /// Ajax has ONLY one pageLoad allowed, wo instead, we register a load script each time the WUC is rendered
        /// </summary>
        void LoadJavascript()
        {
            System.Text.StringBuilder s = new System.Text.StringBuilder();
            s.Append("Sys.Application.add_load(");
            // start of load
            s.AppendLine("function() {");

            //s.AppendLine("debugger;");
            s.AppendLine("var $tbDateTime = $(\"#" + tbDateTime.ClientID + "\")");
            s.AppendLine(".attr(\"readonly\", \"readonly\")");
            s.AppendLine(".css(\"text-align\", \"center\")");
            s.AppendLine(".css(\"cursor\", \"pointer\");");

            s.AppendLine();

            s.AppendLine("$tbDateTime.datetimepicker({");
            s.AppendLine("showSecond: false,");
            s.AppendLine("dateFormat: \"dd-M-yy\",");
            s.AppendLine("timeFormat: 'HH:mm',");
            s.AppendLine("stepHour: 1,");
            s.AppendLine("stepMinute: 15,");
            s.AppendLine("onClose: function (dateText, inst) {");
            s.AppendLine("}");
            s.AppendLine("});");

            // end of load
            s.AppendLine("});");

            ScriptManager.RegisterStartupScript(this, this.GetType(), "DateTimePickerLoad_" + this.ID, s.ToString(), true);
        }
    }

    public class DateTimeEventArgs : EventArgs
    {
        public DateTime? UtcDateTime { get; set; }
    }
}

/*
$(document).ready(function () {
    /// runs in non-Ajax panel pages (no partial page updates)
    /// Set up date textbox
    var $tbDateTime = $("#<%= tbDateTime.ClientID %>")
         .attr("readonly", "readonly")
         .css("text-align", "center")
         .css("cursor", "pointer");

    $tbDateTime.datetimepicker({
        showSecond: false,
        dateFormat: "dd-M-yy",
        timeFormat: 'HH:mm',
        stepHour: 1,
        stepMinute: 15,
        onClose: function (dateText, inst) {
            //__doPostBack('<%= tbDateTime.ClientID %>', '');
        }
    });
});
 * 
 * 
<script type="text/javascript">

Sys.Application.add_load(function () {
    /// runs in non-Ajax panel pages (no partial page updates)
    /// Set up date textbox

    debugger;

    var $tbDateTime = $("#<%= tbDateTime.ClientID %>")
             .attr("readonly", "readonly")
             .css("text-align", "center")
             .css("cursor", "pointer");

    $tbDateTime.datetimepicker({
        showSecond: false,
        dateFormat: "dd-M-yy",
        timeFormat: 'HH:mm',
        stepHour: 1,
        stepMinute: 15,
        onClose: function (dateText, inst) {
            //__doPostBack('<%= tbDateTime.ClientID %>', '');
        }
    });
});
</script>
*/

