﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace BT.Health.SchedulingWeb.User_Controls
{
    public partial class WucDataSelector : System.Web.UI.UserControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// Gets or sets the header text
        /// </summary>
        public string HeaderText
        {
            get { return lblDataType.Text; }
            set { lblDataType.Text = value; }
        }

        /// <summary>
        /// Gets the list of ID's for the items selected
        /// </summary>
        public List<int> SelectedItems
        {
            get
            {
                List<int> list = new List<int>();

                foreach (ListItem li in cb.Items)
                {
                    if (li.Selected)
                    {
                        int val = 0;
                        if (int.TryParse(li.Value, out val))
                            list.Add(val);
                    }
                }

                return list;
            }
        }

        /// <summary>
        /// Gets or sets the name of the field that uses the text item
        /// </summary>
        public string DataTextField
        {
            get { return cb.DataTextField; }
            set { cb.DataTextField = value; }
        }

        /// <summary>
        /// Gets or sets the name of the field that uses the value item
        /// </summary>
        public string DataValueField
        {
            get { return cb.DataValueField; }
            set { cb.DataValueField = value; }
        }

        /// <summary>
        /// Gets or sets the datasource during teh current get/post
        /// </summary>
        public object DataSource
        {
            get { return cb.DataSource; }
            set { cb.DataSource = value; }
        }

        /// <summary>
        /// bind the list
        /// </summary>
        public void DataBind()
        {
            cb.DataBind();
        }
    }
}