﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MedRed.Services;
using MedRed.Services.Interfaces;
using Shared.Model.Config.MDWS;
using Shared.Model;
using Shared.Model.UserRoles;
using BT.Health.SchedulingWeb.UISession;

namespace BT.Health.SchedulingWeb
{
    public class UserRoleActions
    {
        List<string> _actionKeys = new List<string>();

        /// <summary>
        /// Gets a list of action keys available to the user
        /// </summary>
        public List<string> ActionKeys
        {
            get { return _actionKeys; }
        }

        bool _isAdmin = false;

        /// <summary>
        /// Gets whether the user is in the admin role
        /// </summary>
        public bool IsAdmin
        {
            get { return _isAdmin; }
        }

        public UserRoleActions()
        {
        }

        /// <summary>
        /// Get an instance of role actions for the user
        /// </summary>
        /// <param name="userId"></param>
        public UserRoleActions(Page Page, int userId)
        {
            LoadUserActions(Page, userId);
        }

        public void LoadUserActions(Page Page, int userId)
        {
            _actionKeys.Clear();

            Factory factory = Helper.GetFactory(Page);
            var service = factory.GetAccountService();

            var user = service.GetUser(userId);

            var adminRole = (from x in user.Roles
                             where x.Role.Name == "Administrator"
                             select x).FirstOrDefault();

            if (adminRole != null)
            {
                _isAdmin = true;
            }
            else
            {
                foreach (var role in user.Roles)
                {
                    var actions = role.Role.Actions;

                    foreach (var action in actions)
                    {
                        if (!_actionKeys.Contains(action.Key))
                            _actionKeys.Add(action.Key);
                    }
                }
            }
        }

        /// <summary>
        /// Gets whether a user has the requested action
        /// Always returns TRUE for admin users
        /// </summary>
        /// <param name="actionKey"></param>
        /// <returns></returns>
        public bool HasAction(string actionKey)
        {
            if (_isAdmin)
            {
                return true;
            }
            else
            {
                return _actionKeys.Contains(actionKey);
            }
        }
    }
}