﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Shared.Model;

namespace BT.Health.SchedulingWeb.UISession
{
    public class RecentPatients
    {

        private int maxRecent = 10;
        private ArrayList recentPatients = new ArrayList();
        private Shared.Model.Patient currentPatient;


        public void Add(Shared.Model.Patient patient)
        {
            if (recentPatients.Contains(patient))
            {
                recentPatients.Remove(patient);
            }

            recentPatients.Add(patient);
            
            if (recentPatients.Count > maxRecent)
            {
                recentPatients.Remove(recentPatients[0]);
            }

        }

        public void MakeCurrent(Shared.Model.Patient patient)
        {
            currentPatient = patient;

        }

        public List<Shared.Model.Patient> GetRecentPatients()
        {
            Shared.Model.Patient[] recPatients= (Shared.Model.Patient[])recentPatients.ToArray(typeof(Shared.Model.Patient));

            return recPatients.ToList<Shared.Model.Patient>();
        }

        public Shared.Model.Patient GetCurrentPatient()
        {
            return currentPatient;
        }

    }
}