﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services.Interfaces;

namespace BT.Health.SchedulingWeb.Patient
{
    public partial class PatientAppointmentEdit : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // must have a patient to proceed
                UserSession userSession = Helper.GetUserSession(Page);

                if (userSession.PatientList.GetCurrentPatient() != null)
                {
                    Appointment appointment = null;

                    var factory = Helper.GetFactory(Page);
                    var appointmentService = factory.GetAppointmentService();

                    int appointmentId = 0;

                    if (Request.QueryString["id"] != null)
                    {
                        int.TryParse(Request.QueryString["id"], out appointmentId);

                        if (appointmentId > 0)
                        {
                            appointment = appointmentService.Get(appointmentId);

                            if (appointment != null)
                            {
                                if (appointment.Patient.Id != userSession.PatientList.GetCurrentPatient().Id)
                                {
                                    mv.ActiveViewIndex = 2;
                                    lblInvalidAppointment.Text = "Appointment Id= [" + appointment.Id.ToString() + "] at " + appointment.Section.Name + " on " + appointment.Time.ToMediumFormat();
                                    appointment = null;
                                }
                            }
                        }
                    }

                    if (appointment != null)
                    {
                        LoadAppointmentData(appointment);

                    }
                    else
                    {
                        lblMessage.Text = "Not a valid apoointment for the current patient";
                    }
                }
            }
        }

        void LoadAppointmentData(Appointment appt)
        {
            //               ddlProviders.Items.Clear();
            //           ddlRooms.Items.Clear();
            //          ddlEquipment.Items.Clear();
            ddlAppointmentType.Items.Clear();

            int clinicId = appt.Section.Id;

            UserSession userSession = Helper.GetUserSession(Page);

            var factory = Helper.GetFactory(Page);

            int siteId = userSession.CurrentSite.Id;

            // get available resources for the clinic
            var resourceService = factory.GetResourceService();
            var resources = resourceService.GetAll(clinicId);

            //-----------------------------------------------
            var providerService = factory.GetProviderService();
            var providers = providerService.GetAllForSite(siteId).ToList();

            // get providers who are resources at the clinic
            var resourceProviders = (from r in resources
                                     join p in providers
                                     on r.FullfillingResourceId equals p.Id
                                     where r.Type == ResourceType.Provider
                                     orderby p.Person.LastName
                                     select new BasicResourceData
                                     {
                                         ResourceId = r.Id,
                                         ResourceType = Shared.Model.ResourceType.Provider,
                                         ResourceName = r.Name + " (" + p.Person.GetFullName() + ")"
                                     }).ToList();

            ddlProviders.DataValueField = "ResourceId";
            ddlProviders.DataTextField = "ResourceName";
            ddlProviders.DataSource = resourceProviders;
            ddlProviders.DataBind();

            //-----------------------------------------------
            var roomService = factory.GetRoomService();
            var allRooms = roomService.GetAllForSite(siteId).ToList();
            var allRoomResources = resourceService.GetAllOfType(clinicId, ResourceType.Room);

            var rooms = (from r in allRoomResources
                         join a in allRooms
                         on r.FullfillingResourceId equals a.Id
                         orderby r.Name
                         select new BasicResourceData
                         {
                             ResourceId = r.Id,
                             ResourceName = r.Name + " (" + a.Name + " - floor + " + a.Floor + ")"
                         }).ToList();

            ddlRooms.DataValueField = "ResourceId";
            ddlRooms.DataTextField = "ResourceName";
            ddlRooms.DataSource = rooms;
            ddlRooms.DataBind();

            // rooms are optional - prepend an empty selection
            ddlRooms.Items.Insert(0, new ListItem("No room required", "0"));
            ddlRooms.SelectedIndex = 0;

            //-----------------------------------------------
            var equipmentService = factory.GetEquipmentService();
            var allEquipment = equipmentService.GetAllForSite(siteId);
            var allEquipmentResources = resourceService.GetAllOfType(clinicId, ResourceType.Equipment);

            var equipment = (from r in allEquipmentResources
                             join e in allEquipment
                             on r.FullfillingResourceId equals e.Id
                             orderby r.Name
                             select new BasicResourceData
                             {
                                 ResourceId = r.Id,
                                 ResourceName = r.Name + " (" + e.Name + " - type " + e.Type + ")"
                             }).ToList();

            ddlEquipment.DataValueField = "ResourceId";
            ddlEquipment.DataTextField = "ResourceName";
            ddlEquipment.DataSource = equipment;
            ddlEquipment.DataBind();

            // equipment optional
            ddlEquipment.Items.Insert(0, new ListItem("No equipment required", "0"));
            ddlEquipment.SelectedIndex = 0;

            //-----------------------------------------------
            var appointmentTypes = (from t in appt.Section.AppointmentTypes
                                    orderby t.Name
                                    select new BasicResourceData
                                    {
                                        ResourceId = t.Id,
                                        ResourceName = t.Name
                                    }).ToList();

            ddlAppointmentType.DataValueField = "ResourceId";
            ddlAppointmentType.DataTextField = "ResourceName";
            ddlAppointmentType.DataSource = appointmentTypes;
            ddlAppointmentType.DataBind();
        }

        protected void btnCancelNo_Click(object sender, EventArgs e)
        {
            mv.ActiveViewIndex = 0;
        }

        protected void btnCancelYes_Click(object sender, EventArgs e)
        {
            // cancel the appointment
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            mv.ActiveViewIndex = 1;
        }

        protected void btnReschedule_Click(object sender, EventArgs e)
        {

        }

        protected void btnSave_Click(object sender, EventArgs e)
        {

        }
    }
}