﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Patient/Patient.master" AutoEventWireup="true" CodeBehind="PatientAppointmentEdit.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.PatientAppointmentEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h4>Edit Patient Appointment</h4>
            <div>
                <div style="height: 20px;">
                    <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
                </div>
            </div>
            <div>
                <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl="~/Patient/PatientAppointmentList.aspx">Return to the Appointment list</asp:HyperLink>

            </div>
            <asp:MultiView ID="mv" runat="server" ActiveViewIndex="0">
                <asp:View ID="ViewAppointment" runat="server">
                    <table class="tblDataEntry">
                        <thead>
                            <tr>
                                <th colspan="2">Appointment Details</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Clinic</td>
                                <td>
                                    <asp:Label ID="lblClinic" runat="server"></asp:Label></td>
                            </tr>
                            <tr>
                                <td>Appointment Time</td>
                                <td>
                                    <asp:Label ID="lblAppointmentTime" runat="server"></asp:Label></td>
                            </tr>
                            <tr>
                                <td>Appointment Length</td>
                                <td>
                                    <asp:Label ID="lblAppointmentLength" runat="server"></asp:Label></td>
                            </tr>

                            <tr>
                                <td>Appointment Type</td>
                                <td>
                                    <asp:DropDownList ID="ddlAppointmentType" runat="server"></asp:DropDownList></td>
                            </tr>

                            <tr>
                                <td>Provider</td>
                                <td>
                                    <asp:DropDownList ID="ddlProviders" runat="server"></asp:DropDownList></td>
                            </tr>


                            <tr>
                                <td>Room</td>
                                <td>
                                    <asp:DropDownList ID="ddlRooms" runat="server"></asp:DropDownList></td>
                            </tr>

                            <tr>
                                <td>Equipment</td>
                                <td>
                                    <asp:DropDownList ID="ddlEquipment" runat="server"></asp:DropDownList></td>
                            </tr>


                            <tr>
                                <td colspan="2" style="text-align: right;">
                                    <asp:Button ID="btnSave" runat="server" Text="Save Changes" OnClick="btnSave_Click" />
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <div style="margin-top: 40px;">
                        <h5>Other Options</h5>
                        <asp:Button ID="btnReschedule" runat="server" Text="Reschedule the Appointment" OnClick="btnReschedule_Click" />
                        <br />
                        <br />
                        <asp:Button ID="btnCancel" runat="server" Text="Cancel the Appointment" OnClick="btnCancel_Click" />
                    </div>
                </asp:View>
                <asp:View ID="ViewAppointmentCancel" runat="server">
                    <fieldset>
                        <legend>Keep the Appointment</legend>
                        <div style="padding: 20px; width: 400px;">

                            <p>If you do not wish to cancel the appointment, <em>return</em> to the details view</p>
                            <asp:Button ID="btnCancelNo" runat="server" Text="Return to details view" OnClick="btnCancelNo_Click" />
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Cancel the Appointment</legend>
                        <div style="padding: 20px; width: 400px;">

                            <p>Are you sure you want to cancel this appointment?</p>
                            <asp:Button ID="btnCancelYes" runat="server" Text="Yes - Cancel the Appointment" OnClick="btnCancelYes_Click" />
                        </div>
                    </fieldset>
                </asp:View>
                <asp:View runat="server" ID="viewInvalidAppointment">
                    <h3>Invalid Appointment</h3>
                    <p>The selected appointmengt is not valid for this patient</p>
                    <asp:Label ID="lblInvalidAppointment" runat="server" Text="Label"></asp:Label>
                </asp:View>
            </asp:MultiView>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
