﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;
using Shared.Model;
using MedRed.Services;
using System.Configuration;
using System.Text.RegularExpressions;


namespace BT.Health.SchedulingWeb.UISession
{
    public class Helper
    {
        /// <summary>
        /// Gets the default Vista Site Id from Web Config [DefaultVistaSiteId]
        /// </summary>
        public static string DefaultVistaId
        {
            get
            {
                return ConfigurationManager.AppSettings["DefaultVistaSiteId"];
            }
        }

        public static Shared.Model.Patient GetCurrentPatient(System.Web.UI.Page page)
        {
            UserSession userSession = (UserSession)page.Session["UserSession"];

            Shared.Model.Patient currentPatient = null;

            if (userSession != null)
            {
                currentPatient = userSession.PatientList.GetCurrentPatient();
            }

            return currentPatient;
        }

        public static Shared.Model.User GetCurrentUserAccount(System.Web.UI.Page page)
        {
            UserSession userSession = (UserSession)page.Session["UserSession"];

            Shared.Model.User currentUserAccount = null;

            if (userSession != null)
            {
                currentUserAccount = userSession.UserAccount;
            }

            return currentUserAccount;
        }

        public static void SetCurrentUserAccount(System.Web.UI.Page page, Shared.Model.User userAccount)
        {
            UserSession userSession = (UserSession)page.Session["UserSession"];

            userSession.UserAccount = userAccount;

            //------------------------------------------------
            // Load in all actions available to the user
            userSession.UserActions.LoadUserActions(page, userAccount.Id);
        }


        public static void SetUserSession(System.Web.UI.Page page, UserSession userSession)
        {
            page.Session["UserSession"] = userSession;

        }

        public static UserSession GetUserSession(System.Web.UI.Page page)
        {
            UserSession userSession = (UserSession)page.Session["UserSession"];

            return userSession;

        }

        public static Factory GetFactory(System.Web.UI.Page page)
        {
            //UserSession userSession = Helper.GetUserSession(page);


            return Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());


            //Collection<Facility> facilityList = new Collection<Facility>();

            //Factory factory = null;

            //if (userSession != null)
            //{
            //Shared.Model.Site currentSite = userSession.CurrentSite;
            //Factory.GetFactory(UISession.UserSession.

            //factory = Factory.GetFactory(ConnectionHelper.GetVistAEMRConfig(), ConnectionHelper.GetConnectionFor(userSession.Instance.SiteID));
            /*
            if (userSession.Instance.ConnectionType == "Default")
            {
                factory = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
            }
            else
            {
                factory = Factory.GetFactory(ConnectionHelper.GetVistAEMRConfig());
            }
             * */
            //}

            //           return factory;
        }


        public static int GetQueryStringInt(string queryStringValue)
        {
            int id = 0;

            if (queryStringValue != null)
            {
                Int32.TryParse(queryStringValue, out id);
            }

            return id;
        }

        public static string GetQueryString(string queryStringValue)
        {

            if (queryStringValue != null)
            {
                return queryStringValue;
            }

            return "";
        }

        public static string GetSSN(string ssn)
        {

            if (ssn != null)
            {
                if (ssn.Length == 9)
                {
                    if (Regex.IsMatch(ssn, @"^\d+$"))
                    {
                        ssn = String.Format("{0:000-00-0000}", Convert.ToInt32(ssn));
                    }
                }

                return ssn;
            }

            return "";
        }

        public static string GetTelephone(string tele)
        {

            if (tele != null)
            {
                if (tele.Length == 10)
                {
                    if (Regex.IsMatch(tele, @"^\d+$"))
                    {
                        tele = String.Format("{0:000-000-0000}", Convert.ToInt64(tele));
                    }
                }

                return tele;
            }

            return "";
        }

    }
}
