﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;
using Shared.Model;
using MedRed.Services;
using Shared.Model.Config.MDWS;
using BT.Health.SchedulingWeb.UISession;
using System.Reflection;

namespace BT.Health.SchedulingWeb
{
    public partial class SiteMaster : System.Web.UI.MasterPage
    {
        protected override void OnInit(EventArgs e)
        {
            if (Session["UserSession"] == null)
            {
                try
                {
                    // clear login
                    FormsAuthentication.SignOut();
                }
                catch (System.Exception ex)
                {
                    ex.Log();
                }

                // go home - enforces a logon 
                Response.Redirect("~/default.aspx", false);
            }

            //----------------------------------
            base.OnInit(e);

            WucVistaSiteSelector1.VistaSiteSelected += WucVistaSiteSelector1_VistaSiteSelected;
        }

        void WucVistaSiteSelector1_VistaSiteSelected(object sender, CommandEventArgs e)
        {
            if (e.CommandName == "SelectVistaSite")
            {
                try
                {
                    Factory f = Factory.GetFactory(MDWSConfiguration_ConfigHelper.GetDefaultConfig());
                    var service = f.GetSiteService();
                    var site = service.GetFromVistaSiteId(e.CommandArgument.ToString());

                    if (site != null)
                    {
                        // set as current site
                        UISession.Helper.GetUserSession(Page).CurrentSite = site;

                        // redirect back to the current page to ensure the correct data within the site is shown
                        Response.Redirect("~/default.aspx", false);
                    }
                }
                catch (System.Exception ex)
                {
                    Response.Write("<script>alert('" + ex.Message + " - This has been logged');</script>");
                    ex.Log();
                }
            }

            mvVistaSite.ActiveViewIndex = 0;
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // only needs doing once
                LoadAssemblyInfo();
            }
        }

        protected void LoadAssemblyInfo()
        {
            lblBuildNumber.Text = string.Format("Build: {0}", Assembly.GetExecutingAssembly().GetName().Version.ToString());
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            try
            {
                if (!IsPostBack)
                {
                    lblUser.Text = Page.User.Identity.Name;

                    SetSelectedVistaSite();
                }

                // call on initial page load to create dynamic content - call again each postback in the init event to recconect events
                // Recreate on PreRender when new content
                //if (!IsPostBack)

                // get session - will not exist if user logs out
                UserSession session = UISession.Helper.GetUserSession(Page);
                if (session != null)
                {
                    // render menu
                    session.UserMenu.RenderMenuItems(pnlMenu);

                    // show breadcrumb
                    session.UserPageUIHelper.RenderBreadcrumb(Page, pnlBreadcrumb, Page.AppRelativeVirtualPath);

                    // get page title
                    Page.Header.Title = session.UserPageUIHelper.PageTitle(Page.AppRelativeVirtualPath);
                }
            }
            catch (System.Exception ex)
            {
                Response.Write("<script>alert('" + ex.Message + " - This has been logged');</script>");
                ex.Log();
            }
        }

        protected void lbLogOut_Click(object sender, EventArgs e)
        {
            // clear the session
            Session.Clear();
            Session.Abandon();

            // sign out of authentication system
            FormsAuthentication.SignOut();

            // goto default page
            Response.Redirect("~/default.aspx", false);
        }

        protected void lbVistaSite_Click(object sender, EventArgs e)
        {
            // show selection view
            mvVistaSite.ActiveViewIndex = 1;

            WucVistaSiteSelector1.ShowVistaSites(lbVistaSite.CommandArgument.ToString());
        }


        void SetSelectedVistaSite()
        {
            var session = UISession.Helper.GetUserSession(Page);

            if (session != null)
            {
                lbVistaSite.Text = session.CurrentSite.Name;
                lbVistaSite.CommandArgument = session.CurrentSite.VistaSiteId.ToString();

                TimeZoneInfo tzi = null;

                if (session.CurrentSite.TimeZoneId != null)
                {
                    tzi = TimeZoneInfo.FindSystemTimeZoneById(session.CurrentSite.TimeZoneId);
                }

                if (tzi != null)
                {
                    lblSiteTimeZone.Text = (tzi.DisplayName);
                }
                else
                {
                    lblSiteTimeZone.Text = "WARNING - a time zone for the site is not set";
                }
            }
            else
            {
                lbVistaSite.Text = "No Site Selected";
            }
        }

        protected void lbCloseWindow_Click(object sender, EventArgs e)
        {
            mvVistaSite.ActiveViewIndex = 0;
        }
    }
}
