﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="WaitingList.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.WaitingList" %>

<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h2>Patient Waiting List</h2>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
            <div style="background-color: #eee; padding: 10px 4px;">
                <span style="display: inline-block; margin-right: 10px;">Facility</span><asp:DropDownList ID="ddlFacility" AutoPostBack="true" runat="server" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>
                <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Clinic</span><asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>
                <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">&nbsp;<asp:CheckBox ID="chkVets" runat="server" AutoPostBack="True" OnCheckedChanged="chkVets_CheckedChanged" Text="Show highest priority only" />
                </span>
            </div>
            <asp:ListView ID="lvAppointmentRequests" runat="server" OnItemCommand="lvAppointmentRequests_ItemCommand" OnItemDataBound="lvAppointmentRequests_ItemDataBound">
                <EmptyDataTemplate>No Outstanding Appointment Requests</EmptyDataTemplate>
                <ItemTemplate>
                    <tr class="gridViewRowStyle">
                        <td><%#Eval("Patient") %></td>
                        <td runat="server" id="tdTime"></td>
                        <td><%#Eval("SSN") %></td>
                        <td><%#Eval("Sex") %></td>
                        <td><%#Eval("DOB") %></td>
                        <td><%#Eval("Reason") %></td>
                        <td style="text-align: right;"><%#Eval("RequestAge") %></td>
                        <td style="text-align: center;"><%#Eval("Priority") %></td>
                        <td>
                            <asp:LinkButton ID="LinkButton1" runat="server" CommandName="AddAppointment" CommandArgument='<%#Eval("Id") %>'>Add&nbsp;Appointment</asp:LinkButton>
                        </td>
                    </tr>
                </ItemTemplate>
                <AlternatingItemTemplate>
                    <tr class="gridViewAlternatingRowStyle">
                        <td><%#Eval("Patient") %></td>
                        <td runat="server" id="tdTime"></td>
                        <td><%#Eval("SSN") %></td>
                        <td><%#Eval("Sex") %></td>
                        <td><%#Eval("DOB") %></td>
                        <td><%#Eval("Reason") %></td>
                        <td style="text-align: right;"><%#Eval("RequestAge") %></td>
                        <td style="text-align: center;"><%#Eval("Priority") %></td>
                        <td>
                            <asp:LinkButton ID="LinkButton1" runat="server" CommandName="AddAppointment" CommandArgument='<%#Eval("Id") %>'>Add&nbsp;Appointment</asp:LinkButton>
                        </td>
                    </tr>
                </AlternatingItemTemplate>
                <LayoutTemplate>
                    <table class="gridView" style="margin: 10px auto;">
                        <thead>
                            <th>Patient</th>
                            <th>Requested Date</th>
                            <th>SSN</th>
                            <th>Sex</th>
                            <th>Date of Birth</th>
                            <th>Reason</th>
                            <th>Request Age (Days)</th>
                            <th>Priority</th>
                            <th>Fulfill</th>
                        </thead>
                        <tbody>
                            <tr runat="server" id="itemPlaceholder"></tr>
                        </tbody>
                    </table>
                </LayoutTemplate>
            </asp:ListView>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
