﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using MedRed.Services;
using Shared.Model.Config.MDWS;
using Shared.Model;
using BT.Health.SchedulingWeb.UISession;
using MedRed.Services.Interfaces;

namespace BT.Health.SchedulingWeb.Patient
{
    public partial class ResourceView : System.Web.UI.Page
    {
        bool _refreshAppointmentCalendar = false;

        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                lblMessage.Text = string.Empty;

                if (!IsPostBack)
                {
                    // there are always resourtce types
                    LoadResourceTypesDdl();

                    // load any facilities
                    LoadFacilitiesDdl();
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            try
            {
                if (_refreshAppointmentCalendar)
                {
                    Factory factory = Helper.GetFactory(Page);
                    var appointmentService = factory.GetAppointmentService();
                    var appointments = (from a in appointmentService.GetForResource(ddlResource.SelectedValueAsInt(), DateTime.UtcNow.Date, null)
                                        orderby a.Time
                                        select a).ToList();

                    WucPatientAppointmentViewCalendar1.ShowAppointments(appointments);
                }
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        void LoadFacilitiesDdl()
        {
            // show "no resources"
            ddlResource.Items.Clear();
            ddlResource.Items.Add(new ListItem("No resources", "-1")); // Enum Id's usually start at 0, although could be any int

            Factory factory = Helper.GetFactory(Page);
            var facilityService = factory.GetFacilityService();

            int siteId = Helper.GetUserSession(Page).CurrentSite.Id;

            ddlFacility.DataValueField = "Id";
            ddlFacility.DataTextField = "Name";
            ddlFacility.DataSource = (from f in facilityService.GetAll(siteId)
                                      orderby f.Name
                                      select new
                                      {
                                          Id = f.Id,
                                          Name = f.Name
                                      }).ToList();
            ddlFacility.DataBind();

            if (ddlFacility.Items.Count > 0)
            {
                ddlFacility.SelectedIndex = 0;
                ShowResourcesForFacilityAndType();
            }
        }

        /// <summary>
        /// Show a list of the types of resource (which there will always be)
        /// </summary>
        void LoadResourceTypesDdl()
        {
            // get the resource types
            ExtensionMethods.FillDropDownListWithEnumValues(typeof(ResourceType), ddlResourceType);

            // make first item the selected one
            if (ddlResourceType.Items.Count > 0)
                ddlResourceType.SelectedIndex = 0;
        }

        /// <summary>
        /// Fill the reource list for a facility (and by resource type)
        /// </summary>
        void ShowResourcesForFacilityAndType()
        {
            Factory factory = Helper.GetFactory(Page);
            var resourceService = factory.GetResourceService();

            ddlResource.DataValueField = "Id";
            ddlResource.DataTextField = "Name";
            ddlResource.DataSource = (from r in resourceService.GetAllOfType(ddlFacility.SelectedValueAsInt(), SelectedResourceType)
                                      orderby r.Name
                                      select r).ToList();
            ddlResource.DataBind();

            if (ddlResource.Items.Count == 0)
            {
                // show "no resources"
                ddlResource.Items.Clear();
                ddlResource.Items.Add(new ListItem("No resources", "-1")); // Enum Id's usually start at 0, although could be any int
            }
        }


        /// <summary>
        /// Gets the selected resource type - there will always be one
        /// </summary>
        ResourceType SelectedResourceType
        {
            get
            {
                ResourceType rt = ResourceType.Provider;

                if (ddlResourceType.SelectedIndex >= 0)
                {
                    Enum.TryParse(ddlResourceType.SelectedValue, out rt);
                }

                return rt;
            }
        }

        protected void ddlResourceType_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                // when the type of resource changes we just need to show the appointments for that resource type
                ShowResourcesForFacilityAndType();
                _refreshAppointmentCalendar = true;
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void ddlFacility_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                // when the facility changes we need to show the resources at that facility
                ShowResourcesForFacilityAndType();
                _refreshAppointmentCalendar = true;
            }
            catch (System.Exception ex)
            {
                lblMessage.Text = ex.Message; ex.Log();
            }
        }

        protected void ddlResource_SelectedIndexChanged(object sender, EventArgs e)
        {
            // when the resource changes we need to show the appointments for that resource
            _refreshAppointmentCalendar = true;
        }
    }
}