﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="ProviderRoster.aspx.cs" Inherits="BT.Health.SchedulingWeb.Patient.ProviderRoster" %>

<%@ Register Src="~/User_Controls/WucPatientAppointmentViewCalendar.ascx" TagName="WucPatientAppointmentViewCalendar" TagPrefix="uc1" %>
<%@ Register Src="~/User_Controls/WucAjaxLoading.ascx" TagName="WucAjaxLoading" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <h2>Provider Roster</h2>
            <div style="height: 20px;">
                <asp:Label ID="lblMessage" runat="server" ForeColor="Red"></asp:Label>
            </div>
            <asp:MultiView ID="mv" runat="server" ActiveViewIndex="0">
                <asp:View ID="viewProviderRoster" runat="server">
                    <div>
                        <asp:Button ID="btnViewProviderPatientList" runat="server" Text="View Patient List" OnClick="btnViewProviderPatientList_Click" />
                    </div>
                    <div>Click an appointment to view in patient's appointment list</div>
                    <uc1:WucAjaxLoading ID="WucAjaxLoading1" runat="server" />
                    <div style="background-color: #eee; padding: 10px 4px;">
                        <span style="display: inline-block; margin-right: 10px;">Provider</span>
                        <asp:DropDownList ID="ddlProvider" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlProvider_SelectedIndexChanged"></asp:DropDownList>

                        <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Facility</span>
                        <asp:DropDownList ID="ddlFacility" AutoPostBack="true" runat="server" OnSelectedIndexChanged="ddlFacility_SelectedIndexChanged"></asp:DropDownList>

                        <span style="display: inline-block; margin-left: 40px; margin-right: 10px;">Clinic</span>
                        <asp:DropDownList ID="ddlClinic" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlClinic_SelectedIndexChanged"></asp:DropDownList>
                    </div>
                    <div style="margin-top: 10px;">
                        <uc1:WucPatientAppointmentViewCalendar ID="WucPatientAppointmentViewCalendar1" runat="server" />
                    </div>
                </asp:View>
                <asp:View ID="viewProviderPatientList" runat="server">
                    <div>
                        <asp:Button ID="btnViewRoster" runat="server" Text="View Roster" OnClick="btnViewRoster_Click" />
                    </div>
                    <div style="background-color: #eee; padding: 10px 4px;">
                        <span style="display: inline-block; margin-right: 10px;">Site Provider</span>
                        <asp:DropDownList ID="ddlProviderPatientList" runat="server" AutoPostBack="true" OnSelectedIndexChanged="ddlProviderPatientList_SelectedIndexChanged"></asp:DropDownList>
                        <span style="padding-left: 40px;">Patients with scheduled appointments</span>
                    </div>
                    <div style="margin-top: 10px;">
                        <asp:ListView ID="lvPatients" runat="server" OnItemDataBound="lvPatients_ItemDataBound">
                            <EmptyDataTemplate>No Patitents</EmptyDataTemplate>
                            <ItemTemplate>
                                <tr class="gridViewRowStyle" valign="top">
                                    <td runat="server" id="tdPatientName"></td>
                                    <td runat="server" id="tdAppointments"></td>
                                </tr>
                            </ItemTemplate>
                            <AlternatingItemTemplate>
                                <tr class="gridViewAlternatingRowStyle" valign="top">
                                    <td runat="server" id="tdPatientName"></td>
                                    <td runat="server" id="tdAppointments"></td>
                                </tr>
                            </AlternatingItemTemplate>
                            <LayoutTemplate>
                                <table class="gridView" style="margin: 0 auto;">
                                    <thead>
                                        <th>Patient</th>
                                        <th>Appointments</th>
                                    </thead>
                                    <tbody>
                                        <tr runat="server" id="itemPlaceholder"></tr>
                                    </tbody>
                                </table>
                            </LayoutTemplate>
                        </asp:ListView>
                    </div>
                </asp:View>
            </asp:MultiView>
        </ContentTemplate>
    </asp:UpdatePanel>
</asp:Content>
